/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gatein.api.internal.Parameters;
import org.gatein.api.internal.StringJoiner;
import org.gatein.api.internal.StringSplitter;

public class NodePath
implements Iterable<String>,
Comparable<NodePath>,
Serializable {
    private static final NodePath ROOT_PATH = new NodePath();
    private final List<String> pathList;

    public static NodePath path(String ... elements) {
        return new NodePath(Parameters.requireNonEmpty(elements, "elements"));
    }

    public static NodePath root() {
        return ROOT_PATH;
    }

    public static NodePath fromString(String path) {
        return new NodePath(StringSplitter.splitter("/").trim().ignoreEmptyStrings().split(path));
    }

    private NodePath() {
        this(Collections.emptyList());
    }

    private NodePath(String ... pathList) {
        this(Arrays.asList(pathList));
    }

    private NodePath(List<String> pathList) {
        this.pathList = new ArrayList<String>(pathList);
    }

    public NodePath append(String ... elements) {
        return this.append(new NodePath(Parameters.requireNonNull(elements, "elements")));
    }

    public NodePath append(NodePath path) {
        ArrayList<String> list = new ArrayList<String>(this.pathList.size() + path.pathList.size());
        list.addAll(this.pathList);
        list.addAll(path.pathList);
        return new NodePath(list);
    }

    public NodePath subPath(int fromIndex) {
        return this.subPath(fromIndex, this.size());
    }

    public NodePath subPath(int fromIndex, int toIndex) {
        return new NodePath(new ArrayList<String>(this.pathList.subList(fromIndex, toIndex)));
    }

    public String getSegment(int index) {
        return this.pathList.get(index);
    }

    public String getLastSegment() {
        int size = this.size();
        return size == 0 ? null : this.getSegment(size - 1);
    }

    public NodePath parent() {
        if (this.pathList.isEmpty()) {
            return null;
        }
        return this.subPath(0, this.size() - 1);
    }

    public boolean isParent(NodePath path) {
        if (this.size() >= path.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            String name = this.getSegment(i);
            if (name.equals(path.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.pathList.size();
    }

    public List<String> asList() {
        return Collections.unmodifiableList(this.pathList);
    }

    public String[] asArray() {
        return this.pathList.toArray(new String[this.pathList.size()]);
    }

    @Override
    public int compareTo(NodePath other) {
        int size = this.size();
        int otherSize = other.size();
        for (int i = 0; i < otherSize && i < size; ++i) {
            int result = this.getSegment(i).compareTo(other.getSegment(i));
            if (result == 0) continue;
            return result;
        }
        return size < otherSize ? -1 : (size == otherSize ? 0 : 1);
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<String> iterator = this.pathList.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operation not supported");
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePath that = (NodePath)o;
        return this.pathList.equals(that.pathList);
    }

    public int hashCode() {
        return this.pathList.hashCode();
    }

    public String toString() {
        return StringJoiner.joiner("/").leading().join(this.pathList);
    }
}

