/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import org.exoplatform.services.organization.Membership;

public class MembershipCacheKey
implements Serializable {
    private static final long serialVersionUID = -188435911917156440L;
    private final String userName;
    private final String groupId;
    private final String type;
    private final int hashcode;

    public MembershipCacheKey(String userName, String groupId, String type) {
        this.userName = userName;
        this.groupId = groupId;
        this.type = type;
        int prime = 31;
        int result = 1;
        result = 31 * result + (groupId == null ? 0 : groupId.hashCode());
        result = 31 * result + (type == null ? 0 : type.hashCode());
        this.hashcode = 31 * result + (userName == null ? 0 : userName.hashCode());
    }

    public MembershipCacheKey(Membership m) {
        this.userName = m.getUserName();
        this.groupId = m.getGroupId();
        this.type = m.getMembershipType();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        this.hashcode = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getType() {
        return this.type;
    }

    public String getUserName() {
        return this.userName;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MembershipCacheKey other = (MembershipCacheKey)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

