/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.mop.SiteKey;

public class DynamicPortalLayoutMatcher {
    private String currentSiteNameRegex = null;
    private String siteNameRegex = null;
    private String siteTypeRegex = null;
    private Pattern currentSiteNamePattern = null;
    private Pattern siteNamePattern = null;
    private Pattern siteTypePattern = null;

    public void setCurrentSiteNameRegex(String currentSiteNameRegex) {
        this.currentSiteNameRegex = currentSiteNameRegex;
    }

    public void setSiteNameRegex(String siteNameRegex) {
        this.siteNameRegex = siteNameRegex;
    }

    public void setSiteTypeRegex(String siteTypeRegex) {
        this.siteTypeRegex = siteTypeRegex;
    }

    public Pattern getSiteNamePattern() {
        if (this.siteNamePattern == null && StringUtils.isNotBlank((CharSequence)this.siteNameRegex)) {
            this.siteNamePattern = Pattern.compile(this.siteNameRegex);
        }
        return this.siteNamePattern;
    }

    public Pattern getSiteTypePattern() {
        if (this.siteTypePattern == null && StringUtils.isNotBlank((CharSequence)this.siteTypeRegex)) {
            this.siteTypePattern = Pattern.compile(this.siteTypeRegex);
        }
        return this.siteTypePattern;
    }

    public Pattern getCurrentSiteNamePattern() {
        if (this.currentSiteNamePattern == null && StringUtils.isNotBlank((CharSequence)this.currentSiteNameRegex)) {
            this.currentSiteNamePattern = Pattern.compile(this.currentSiteNameRegex);
        }
        return this.currentSiteNamePattern;
    }

    public boolean matches(SiteKey siteKey, String currentPortalSiteName) {
        if (siteKey == null || StringUtils.isBlank((CharSequence)currentPortalSiteName)) {
            return false;
        }
        if (this.getCurrentSiteNamePattern() != null && !this.getCurrentSiteNamePattern().matcher(currentPortalSiteName).matches()) {
            return false;
        }
        if (this.getSiteNamePattern() != null && !this.getSiteNamePattern().matcher(siteKey.getName()).matches()) {
            return false;
        }
        return this.getSiteTypePattern() == null || this.getSiteTypePattern().matcher(siteKey.getTypeName()).matches();
    }
}

