/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNodeContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.importer.NavigationFragmentImporter;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationState;

public class NavigationImporter {
    private final Locale portalLocale;
    private final PageNavigation src;
    private final NavigationService service;
    private final ImportMode mode;
    private final DescriptionService descriptionService;

    public NavigationImporter(Locale portalLocale, ImportMode mode, PageNavigation src, NavigationService service, DescriptionService descriptionService) {
        this.portalLocale = portalLocale;
        this.mode = mode;
        this.src = src;
        this.service = service;
        this.descriptionService = descriptionService;
    }

    public void perform() {
        ArrayList fragments;
        SiteKey key = new SiteKey(this.src.getOwnerType(), this.src.getOwnerId());
        NavigationContext dst = this.service.loadNavigation(key);
        switch (this.mode) {
            case CONSERVE: {
                if (dst == null) {
                    dst = new NavigationContext(key, new NavigationState(Integer.valueOf(this.src.getPriority())));
                    this.service.saveNavigation(dst);
                    break;
                }
                dst = null;
                break;
            }
            case INSERT: {
                if (dst != null) break;
                dst = new NavigationContext(key, new NavigationState(Integer.valueOf(this.src.getPriority())));
                this.service.saveNavigation(dst);
                break;
            }
            case MERGE: 
            case OVERWRITE: {
                dst = new NavigationContext(key, new NavigationState(Integer.valueOf(this.src.getPriority())));
                this.service.saveNavigation(dst);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (dst != null && (fragments = this.src.getFragments()) != null && fragments.size() > 0) {
            for (NavigationFragment fragment : fragments) {
                List<String> path;
                String parentURI = fragment.getParentURI();
                if (parentURI != null) {
                    String[] names;
                    path = new ArrayList();
                    for (String name : names = parentURI.split("/")) {
                        if (name.length() <= 0) continue;
                        path.add(name);
                    }
                } else {
                    path = Collections.emptyList();
                }
                NavigationFragmentImporter fragmentImporter = new NavigationFragmentImporter(path.toArray(new String[path.size()]), this.service, dst.getKey(), this.portalLocale, this.descriptionService, (PageNodeContainer)fragment, this.mode.config);
                fragmentImporter.perform();
            }
        }
    }
}

