/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.es;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NewsIndexingUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)NewsIndexingUpgradePlugin.class.getName());
    private final RepositoryService repositoryService;
    private static final String COLLABORATION_WS = "collaboration";
    private final IndexingService indexingService;
    private int newsIndexingCount;

    public NewsIndexingUpgradePlugin(InitParams initParams, RepositoryService repositoryService, IndexingService indexingService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.indexingService = indexingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        log.info((Object)"Start unindexing old news activities and indexing old news");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query q = qm.createQuery("select * from exo:news WHERE publication:currentState = 'published' AND jcr:path LIKE '/Groups/spaces/%'", "sql");
            NodeIterator nodeIterator = q.execute().getNodes();
            if (nodeIterator != null) {
                while (nodeIterator.hasNext()) {
                    Node newsNode = nodeIterator.nextNode();
                    this.indexingService.index("news", newsNode.getUUID());
                    String newsActivityId = newsNode.getProperty("exo:activities").getString().split(";")[0].split(":")[1];
                    this.indexingService.unindex("activity", newsActivityId);
                    ++this.newsIndexingCount;
                }
            }
            log.info("End indexing of '{}' old news. It took {} ms", new Object[]{this.newsIndexingCount, System.currentTimeMillis() - startupTime});
        }
    }

    public int getNewsIndexingCount() {
        return this.newsIndexingCount;
    }
}

