/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.targets;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;

public class TargetsDefaultPermissionUpgrade
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)TargetsDefaultPermissionUpgrade.class.getName());
    private MetadataService metadataService;
    private MetadataStorage metadataStorage;
    private int migratedNoDefaultPermissionTargetsCount = 0;

    public TargetsDefaultPermissionUpgrade(InitParams initParams, MetadataService metadataService, MetadataStorage metadataStorage) {
        super(initParams);
        this.metadataService = metadataService;
        this.metadataStorage = metadataStorage;
    }

    public int getMigratedNoDefaultPermissionTargetsCount() {
        return this.migratedNoDefaultPermissionTargetsCount;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start targets migration");
        List<Metadata> noDefaultPermissionTargets = this.metadataService.getMetadatas(NewsTargetingService.METADATA_TYPE.getName(), 0L).stream().filter(target -> target.getProperties().get("permissions") == null).toList();
        int totalNoDefaultPermissionTargetsCount = noDefaultPermissionTargets.size();
        LOG.info("Total number of no default permission targets to be migrated: {}", new Object[]{totalNoDefaultPermissionTargetsCount});
        int notMigratedNoDefaultPermissionTargetsCount = 0;
        int processedNoDefaultPermissionTargetsCount = 0;
        for (List noDefaultPermissionTargetsChunk : ListUtils.partition(noDefaultPermissionTargets, (int)10)) {
            int notMigratedNoDefaultPermissionTargetsCountByTransaction = this.manageNoDefaultPermissionTargets(noDefaultPermissionTargetsChunk);
            int processedNoDefaultPermissionTargetsCountByTransaction = noDefaultPermissionTargetsChunk.size();
            this.migratedNoDefaultPermissionTargetsCount += processedNoDefaultPermissionTargetsCountByTransaction - notMigratedNoDefaultPermissionTargetsCountByTransaction;
            LOG.info("No default permission targets migration progress: processed={}/{} succeeded={} error={}", new Object[]{processedNoDefaultPermissionTargetsCount += processedNoDefaultPermissionTargetsCountByTransaction, totalNoDefaultPermissionTargetsCount, this.migratedNoDefaultPermissionTargetsCount, notMigratedNoDefaultPermissionTargetsCount += notMigratedNoDefaultPermissionTargetsCountByTransaction});
        }
        if (notMigratedNoDefaultPermissionTargetsCount != 0) {
            LOG.warn("End no default permission targets migration with some errors: total={} succeeded={} error={}. It tooks {} ms.The not migrated no default permission targets will be processed again next startup.", new Object[]{totalNoDefaultPermissionTargetsCount, this.migratedNoDefaultPermissionTargetsCount, notMigratedNoDefaultPermissionTargetsCount, System.currentTimeMillis() - startupTime});
            throw new IllegalStateException("Some no default permission targets wasn't executed successfully. It will be re-attempted next startup");
        }
        LOG.info("End no default permission targets successful migration: total={} succeeded={} error={}. It tooks {} ms.", new Object[]{totalNoDefaultPermissionTargetsCount, this.migratedNoDefaultPermissionTargetsCount, notMigratedNoDefaultPermissionTargetsCount, System.currentTimeMillis() - startupTime});
    }

    public int manageNoDefaultPermissionTargets(List<Metadata> noDefaultPermissionTargets) {
        int notMigratedNoDefaultPermissionTargetsCount = 0;
        for (Metadata noDefaultPermissionTarget : noDefaultPermissionTargets) {
            try {
                Map noDefaultPermissionTargetProperties = noDefaultPermissionTarget.getProperties();
                noDefaultPermissionTargetProperties.put("permissions", "/platform/web-contributors");
                noDefaultPermissionTarget.setProperties(noDefaultPermissionTargetProperties);
                this.metadataStorage.updateMetadata(noDefaultPermissionTarget);
            }
            catch (Exception e) {
                LOG.warn("Error migrating no default permission targets with id {}. Continue to migrate other items", new Object[]{noDefaultPermissionTarget.getId(), e});
                ++notMigratedNoDefaultPermissionTargetsCount;
            }
        }
        return notMigratedNoDefaultPermissionTargetsCount;
    }
}

