/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.groovyscript.text.TemplateService;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;

public class Lifecycle<E extends UIComponent> {
    protected static Log log = ExoLogger.getLogger((String)"portal:Lifecycle");

    public void processDecode(E uicomponent, WebuiRequestContext context) throws Exception {
    }

    public void processAction(E uicomponent, WebuiRequestContext context) throws Exception {
        String action = context.getRequestParameter(context.getActionParameterName());
        if (action == null) {
            return;
        }
        Event<UIComponent> event = ((UIComponent)uicomponent).createEvent(action, Event.Phase.PROCESS, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void processRender(E uicomponent, WebuiRequestContext context) throws Exception {
        String template = ((UIComponent)uicomponent).getTemplate();
        if (template == null) {
            throw new IllegalStateException("uicomponent " + uicomponent + " with class " + uicomponent.getClass().getName() + " has no template for rendering");
        }
        ResourceResolver resolver = ((UIComponent)uicomponent).getTemplateResourceResolver(context, template);
        WebuiBindingContext bcontext = new WebuiBindingContext(resolver, context.getWriter(), (UIComponent)uicomponent, context);
        bcontext.put("uicomponent", uicomponent);
        bcontext.put(((UIComponent)uicomponent).getUIComponentName(), uicomponent);
        this.renderTemplate(template, bcontext);
    }

    protected void renderTemplate(String template, WebuiBindingContext bcontext) throws Exception {
        WebuiRequestContext context = bcontext.getRequestContext();
        bcontext.put("locale", context.getLocale());
        ExoContainer pcontainer = context.getApplication().getApplicationServiceContainer();
        TemplateService service = (TemplateService)pcontainer.getComponentInstanceOfType(TemplateService.class);
        ResourceResolver resolver = bcontext.getResourceResolver();
        if (PropertyManager.isDevelopping()) {
            long lastAccess;
            WebuiRequestContext rootContext = (WebuiRequestContext)context.getParentAppRequestContext();
            if (rootContext == null) {
                rootContext = context;
            }
            if ((lastAccess = rootContext.getUIApplication().getLastAccessApplication()) > 0L && resolver.isModified(template, lastAccess)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalidate the template: " + template));
                }
                service.invalidateTemplate(template, resolver);
            }
        }
        try {
            service.merge(template, (BindingContext)bcontext);
        }
        catch (NullPointerException e) {
            log.error((Object)("Template: " + template + " not found."));
        }
    }
}

