/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index.impl;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.search.es.client.ElasticContentRequestBuilder;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticIndexingClient;
import org.exoplatform.commons.search.index.IndexingOperationProcessor;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ElasticIndexingOperationProcessor
extends IndexingOperationProcessor
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(ElasticIndexingOperationProcessor.class);
    private static final String BATCH_NUMBER_PROPERTY_NAME = "exo.es.indexing.batch.number";
    private static final Integer BATCH_NUMBER_DEFAULT = 1000;
    private static final String REQUEST_SIZE_LIMIT_PROPERTY_NAME = "exo.es.indexing.request.size.limit";
    private static final Integer REQUEST_SIZE_LIMIT_DEFAULT = 0xA00000;
    private static final String REINDEXING_BATCH_SIZE_PROPERTY_NAME = "exo.es.reindex.batch.size";
    private static final int REINDEXING_BATCH_SIZE_DEFAULT_VALUE = 100;
    private final IndexingOperationDAO indexingOperationDAO;
    private final ElasticIndexingClient elasticIndexingClient;
    private final ElasticContentRequestBuilder elasticContentRequestBuilder;
    private final ElasticIndexingAuditTrail auditTrail;
    private final EntityManagerService entityManagerService;
    private Integer batchNumber = BATCH_NUMBER_DEFAULT;
    private Integer requestSizeLimit = REQUEST_SIZE_LIMIT_DEFAULT;
    private ExecutorService executors = Executors.newCachedThreadPool();
    private String esVersion;
    private boolean interrupted = false;
    private boolean initialized = false;

    public ElasticIndexingOperationProcessor(IndexingOperationDAO indexingOperationDAO, ElasticIndexingClient elasticIndexingClient, ElasticContentRequestBuilder elasticContentRequestBuilder, ElasticIndexingAuditTrail auditTrail, EntityManagerService entityManagerService, InitParams initParams) {
        this.indexingOperationDAO = indexingOperationDAO;
        this.auditTrail = auditTrail;
        this.entityManagerService = entityManagerService;
        this.elasticIndexingClient = elasticIndexingClient;
        this.elasticContentRequestBuilder = elasticContentRequestBuilder;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME))) {
            this.batchNumber = Integer.valueOf(PropertyManager.getProperty((String)BATCH_NUMBER_PROPERTY_NAME));
        }
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME))) {
            this.requestSizeLimit = Integer.valueOf(PropertyManager.getProperty((String)REQUEST_SIZE_LIMIT_PROPERTY_NAME));
        }
        if (initParams == null || !initParams.containsKey((Object)"es.version")) {
            throw new IllegalStateException("es.version parameter is mandatory");
        }
        this.esVersion = initParams.getValueParam("es.version").getValue();
        LOG.info("Use ES Version {}", new Object[]{this.esVersion});
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector) {
        this.addConnector(indexingServiceConnector, false);
    }

    @Override
    public void addConnector(IndexingServiceConnector indexingServiceConnector, Boolean override) {
        if (this.getConnectors().containsKey(indexingServiceConnector.getConnectorName()) && override.equals(false)) {
            LOG.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{indexingServiceConnector.getConnectorName()});
        } else {
            this.getConnectors().put(indexingServiceConnector.getConnectorName(), indexingServiceConnector);
            LOG.info("An Indexing Connector has been added: {}", new Object[]{indexingServiceConnector.getConnectorName()});
        }
    }

    @Override
    public synchronized void process() {
        if (!this.initialized) {
            LOG.debug((Object)"Skip ES queue processing until service is properly initialized");
            return;
        }
        this.interrupted = false;
        try {
            int processedOperations;
            while ((processedOperations = this.processBulk()) >= this.batchNumber) {
            }
        }
        finally {
            if (this.interrupted) {
                LOG.info((Object)"Indexing queue processing interruption done");
            }
        }
    }

    @Override
    public void interrupt() {
        LOG.info((Object)"Indexing queue processing has been interrupted. Please wait until the service exists cleanly...");
        this.interrupted = true;
    }

    private boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            LOG.info((Object)"Thread running indexing queue processing has been interrupted. Please wait until the service exists cleanly...");
            this.interrupted = true;
        }
        return this.interrupted;
    }

    private int processBulk() {
        EnumMap<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted = new EnumMap<OperationType, Map<String, List<IndexingOperation>>>(OperationType.class);
        long maxIndexingOperationId = 0L;
        List<IndexingOperation> indexingOperations = this.indexingOperationDAO.findAllFirst(this.batchNumber);
        if (indexingOperations.isEmpty()) {
            return 0;
        }
        for (IndexingOperation indexingOperation : indexingOperations) {
            this.putIndexingOperationInMemoryQueue(indexingOperation, indexingQueueSorted);
            if (maxIndexingOperationId >= indexingOperation.getId()) continue;
            maxIndexingOperationId = indexingOperation.getId();
        }
        this.processInit(indexingQueueSorted);
        this.processCUD(indexingQueueSorted);
        if (this.isInterrupted()) {
            throw new IllegalStateException("Indexing queue processing interrupted");
        }
        this.indexingOperationDAO.deleteAllIndexingOperationsHavingIdLessThanOrEqual(maxIndexingOperationId);
        this.entityManagerService.getEntityManager().clear();
        return indexingOperations.size();
    }

    private void putIndexingOperationInMemoryQueue(IndexingOperation indexingOperation, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (!indexingQueueSorted.containsKey((Object)indexingOperation.getOperation())) {
            indexingQueueSorted.put(indexingOperation.getOperation(), new HashMap());
        }
        if (!indexingQueueSorted.get((Object)indexingOperation.getOperation()).containsKey(indexingOperation.getEntityIndex())) {
            indexingQueueSorted.get((Object)indexingOperation.getOperation()).put(indexingOperation.getEntityIndex(), new ArrayList());
        }
        indexingQueueSorted.get((Object)indexingOperation.getOperation()).get(indexingOperation.getEntityIndex()).add(indexingOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCUD(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        String singleRequestOperation;
        ElasticIndexingServiceConnector connector;
        StringBuilder bulkRequest;
        block37: {
            bulkRequest = new StringBuilder();
            if (indexingQueueSorted.containsKey((Object)OperationType.DELETE)) {
                Map<String, List<IndexingOperation>> deleteIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.DELETE);
                for (String entityIndex : deleteIndexingOperationsMap.keySet()) {
                    List<IndexingOperation> deleteIndexingOperationsList;
                    connector = (ElasticIndexingServiceConnector)this.getConnectors().get(entityIndex);
                    if (connector == null || (deleteIndexingOperationsList = deleteIndexingOperationsMap.get(entityIndex)) == null || deleteIndexingOperationsList.isEmpty()) continue;
                    Iterator<IndexingOperation> deleteIndexingOperationsIterator = deleteIndexingOperationsList.iterator();
                    while (deleteIndexingOperationsIterator.hasNext()) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        IndexingOperation deleteIndexQueue = deleteIndexingOperationsIterator.next();
                        try {
                            String deleteDocumentRequestContent = this.elasticContentRequestBuilder.getDeleteDocumentRequestContent(connector, deleteIndexQueue.getEntityId());
                            if (deleteDocumentRequestContent != null) {
                                bulkRequest.append(deleteDocumentRequestContent);
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Error while *deleting* index entry of entity, type = " + entityIndex + ", id =" + (deleteIndexQueue == null ? null : deleteIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                        }
                        finally {
                            indexingQueueSorted.remove((Object)OperationType.DELETE, deleteIndexQueue.getEntityId());
                        }
                        deleteIndexingOperationsIterator.remove();
                        this.deleteOperationsByEntityIdForTypesBefore(new OperationType[]{OperationType.CREATE}, indexingQueueSorted, deleteIndexQueue);
                        this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, deleteIndexQueue);
                        bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                    }
                }
            }
            if (!indexingQueueSorted.containsKey((Object)OperationType.CREATE)) break block37;
            Map<String, List<IndexingOperation>> createIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.CREATE);
            for (String entityIndex : createIndexingOperationsMap.keySet()) {
                List<IndexingOperation> createIndexingOperationsList;
                connector = (ElasticIndexingServiceConnector)this.getConnectors().get(entityIndex);
                if (connector == null || (createIndexingOperationsList = createIndexingOperationsMap.get(entityIndex)) == null || createIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> createIndexingOperationsIterator = createIndexingOperationsList.iterator();
                while (createIndexingOperationsIterator.hasNext()) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    IndexingOperation createIndexQueue = createIndexingOperationsIterator.next();
                    try {
                        if (connector.isNeedIngestPipeline()) {
                            singleRequestOperation = this.elasticContentRequestBuilder.getCreatePipelineDocumentRequestContent(connector, createIndexQueue.getEntityId());
                            if (singleRequestOperation != null) {
                                this.elasticIndexingClient.sendCreateDocOnPipeline(connector.getIndexAlias(), createIndexQueue.getEntityId(), connector.getPipelineName(), singleRequestOperation);
                            }
                            indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                            indexingQueueSorted.remove((Object)OperationType.UPDATE, createIndexQueue.getEntityId());
                        } else {
                            singleRequestOperation = this.elasticContentRequestBuilder.getCreateDocumentRequestContent(connector, createIndexQueue.getEntityId());
                            if (singleRequestOperation != null) {
                                bulkRequest.append(singleRequestOperation);
                            }
                        }
                        createIndexingOperationsIterator.remove();
                    }
                    catch (Exception e) {
                        try {
                            LOG.warn((Object)("Error while *creating* index entry of entity, type = " + entityIndex + ", id =" + (createIndexQueue == null ? null : createIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                            createIndexingOperationsIterator.remove();
                        }
                        catch (Throwable throwable) {
                            createIndexingOperationsIterator.remove();
                            this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                            indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                            throw throwable;
                        }
                        this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                        indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                    }
                    this.deleteOperationsByEntityIdForTypes(new OperationType[]{OperationType.UPDATE}, indexingQueueSorted, createIndexQueue);
                    indexingQueueSorted.remove((Object)OperationType.CREATE, createIndexQueue.getEntityId());
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
        }
        if (indexingQueueSorted.containsKey((Object)OperationType.UPDATE)) {
            Map<String, List<IndexingOperation>> updateIndexingOperationsMap = indexingQueueSorted.get((Object)OperationType.UPDATE);
            for (String entityIndex : updateIndexingOperationsMap.keySet()) {
                List<IndexingOperation> updateIndexingOperationsList;
                connector = (ElasticIndexingServiceConnector)this.getConnectors().get(entityIndex);
                if (connector == null || (updateIndexingOperationsList = updateIndexingOperationsMap.get(entityIndex)) == null || updateIndexingOperationsList.isEmpty()) continue;
                Iterator<IndexingOperation> updateIndexingOperationsIterator = updateIndexingOperationsList.iterator();
                while (updateIndexingOperationsIterator.hasNext()) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    IndexingOperation updateIndexQueue = updateIndexingOperationsIterator.next();
                    try {
                        if (connector.isNeedIngestPipeline()) {
                            singleRequestOperation = this.elasticContentRequestBuilder.getCreatePipelineDocumentRequestContent(connector, updateIndexQueue.getEntityId());
                            if (singleRequestOperation != null) {
                                this.elasticIndexingClient.sendCreateDocOnPipeline(connector.getIndexAlias(), updateIndexQueue.getEntityId(), connector.getPipelineName(), singleRequestOperation);
                            }
                        } else {
                            singleRequestOperation = this.elasticContentRequestBuilder.getUpdateDocumentRequestContent(connector, updateIndexQueue.getEntityId());
                            if (singleRequestOperation != null) {
                                bulkRequest.append(singleRequestOperation);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while *updating* index entry of entity, type = " + entityIndex + ", id =" + (updateIndexQueue == null ? null : updateIndexQueue.getEntityId()) + ", cause:"), (Throwable)e);
                    }
                    finally {
                        indexingQueueSorted.remove((Object)OperationType.UPDATE, updateIndexQueue.getEntityId());
                    }
                    updateIndexingOperationsIterator.remove();
                    bulkRequest = this.checkBulkRequestSizeReachedLimitation(bulkRequest);
                }
            }
        }
        if (bulkRequest.length() > 0 && !this.isInterrupted()) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest.toString());
        }
    }

    private void processInit(Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted) {
        if (indexingQueueSorted.containsKey((Object)OperationType.INIT)) {
            for (String entityIndex : indexingQueueSorted.get((Object)OperationType.INIT).keySet()) {
                IndexingServiceConnector connector = this.getConnectors().get(entityIndex);
                if (this.isInterrupted() || connector == null) {
                    return;
                }
                this.sendInitRequests(connector);
            }
            indexingQueueSorted.remove((Object)OperationType.INIT);
        }
    }

    private void deleteOperationsByEntityIdForTypesBefore(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityIndex())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityIndex()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (indexQueue.getId() <= indexingOperation.getId() || !indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void deleteOperationsByEntityIdForTypes(OperationType[] operations, Map<OperationType, Map<String, List<IndexingOperation>>> indexingQueueSorted, IndexingOperation indexQueue) {
        for (OperationType operation : operations) {
            if (!indexingQueueSorted.containsKey((Object)operation) || !indexingQueueSorted.get((Object)operation).containsKey(indexQueue.getEntityIndex())) continue;
            Iterator<IndexingOperation> iterator = indexingQueueSorted.get((Object)operation).get(indexQueue.getEntityIndex()).iterator();
            while (iterator.hasNext()) {
                IndexingOperation indexingOperation = iterator.next();
                if (!indexingOperation.getEntityId().equals(indexQueue.getEntityId())) continue;
                iterator.remove();
            }
        }
    }

    private void sendInitRequests(IndexingServiceConnector indexingServiceConnector) {
        boolean newlyCreated;
        ElasticIndexingServiceConnector connector = (ElasticIndexingServiceConnector)indexingServiceConnector;
        String indexAlias = connector.getIndexAlias();
        String index = connector.getCurrentIndex();
        boolean useAlias = true;
        if (index == null) {
            index = indexAlias;
            useAlias = false;
        }
        if ((newlyCreated = this.elasticIndexingClient.sendCreateIndexRequest(index, this.elasticContentRequestBuilder.getCreateIndexRequestContent(connector), connector.getMapping())) && useAlias) {
            this.elasticIndexingClient.sendCreateIndexAliasRequest(index, null, indexAlias);
        }
        if (connector.isNeedIngestPipeline()) {
            this.elasticIndexingClient.sendCreateAttachmentPipelineRequest(index, connector.getPipelineName(), connector.getAttachmentProcessor());
        }
    }

    private StringBuilder checkBulkRequestSizeReachedLimitation(StringBuilder bulkRequest) {
        if (bulkRequest.length() >= this.requestSizeLimit) {
            this.elasticIndexingClient.sendCUDRequest(bulkRequest.toString());
            return new StringBuilder();
        }
        return bulkRequest;
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Integer getRequestSizeLimit() {
        return this.requestSizeLimit;
    }

    public void setRequestSizeLimit(Integer requestSizeLimit) {
        this.requestSizeLimit = requestSizeLimit;
    }

    public void start() {
        try {
            String version = this.elasticIndexingClient.sendGetESVersion();
            if (version == null || !version.startsWith(this.esVersion + ".")) {
                LOG.error((Object)("Expected Version of ES version is " + this.esVersion + " but was " + version + ". If this is a compatible version, you can configure 'exo.es.version.minor' to delete this error message."));
            }
            this.initConnectors();
            this.initialized = true;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while initializing ES connectors", (Throwable)e);
        }
    }

    public void stop() {
        this.executors.shutdownNow();
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    private void initConnectors() {
        for (Map.Entry<String, IndexingServiceConnector> entry : this.getConnectors().entrySet()) {
            this.sendInitRequests(entry.getValue());
        }
    }
}

