/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.action;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.clouddrives.CloudDriveContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveManager;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.webui.action.CloudFileActionException;
import org.exoplatform.services.cms.clouddrives.webui.action.CloudFileActionService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudFileAction {
    protected static final Log LOG = ExoLogger.getLogger(CloudFileAction.class);
    protected final String[] emptyParams = new String[0];
    protected final UIJCRExplorer uiExplorer;
    protected final Set<Node> srcNodes = new LinkedHashSet<Node>();
    protected String destWorkspace;
    protected String destPath;
    protected Node destNode;
    protected Node link;
    protected boolean move;

    public CloudFileAction(UIJCRExplorer uiExplorer) {
        this.uiExplorer = uiExplorer;
    }

    public CloudFileAction addSource(Node srcNode) {
        this.srcNodes.add(srcNode);
        return this;
    }

    public CloudFileAction addSource(String srcInfo) throws Exception {
        return this.addSource(this.getNodeByInfo(srcInfo, false));
    }

    public CloudFileAction addSource(String srcWorkspace, String srcPath) throws Exception {
        return this.addSource(this.getNodeByPath(srcWorkspace, srcPath, false));
    }

    public CloudFileAction setDestination(Node destNode) throws Exception {
        this.destWorkspace = destNode.getSession().getWorkspace().getName();
        this.destNode = this.getNodeByPath(this.destWorkspace, destNode.getPath(), true);
        this.destPath = this.destNode.getPath();
        return this;
    }

    public CloudFileAction setDestination(String destInfo) throws Exception {
        return this.setDestination(this.getNodeByInfo(destInfo, true));
    }

    public CloudFileAction move() {
        this.move = true;
        return this;
    }

    public Node getLink() {
        return this.link;
    }

    public String getDestinationWorkspace() {
        return this.destWorkspace;
    }

    public String getDestonationPath() {
        return this.destPath;
    }

    public Node getDestinationNode() {
        return this.destNode;
    }

    public void rollback() throws RepositoryException {
        this.destNode.getSession().refresh(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean apply() throws CloudFileActionException, Exception {
        Iterator<Node> iterator;
        int linksCreated;
        CloudDrive destLocal;
        LinkManager linkManager;
        CloudDriveService driveService;
        DriveData documentsDrive;
        CloudFileActionService actions;
        String groupId;
        Space destSpace;
        if (this.destWorkspace == null) {
            throw new CloudFileActionException("Destination should be defined.", new ApplicationMessage("CloudFile.msg.DestinationNotDefined", (Object[])this.emptyParams));
        }
        if (PermissionUtil.canAddNode((Node)this.destNode) && !this.uiExplorer.nodeIsLocked(this.destNode) && this.destNode.isCheckedOut()) {
            if (this.srcNodes.size() <= 0) {
                throw new CloudFileActionException("Source should be defined.", new ApplicationMessage("CloudFile.msg.SourceNotDefined", (Object[])this.emptyParams));
            }
            destSpace = null;
            groupId = null;
            actions = (CloudFileActionService)WCMCoreUtils.getService(CloudFileActionService.class);
            documentsDrive = this.uiExplorer.getDriveData();
            if (documentsDrive != null && actions.isGroupDrive(documentsDrive)) {
                groupId = documentsDrive.getName().replace('.', '/');
                SpaceService spaces = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
                destSpace = spaces.getSpaceByGroupId(groupId);
            }
            driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            destLocal = driveService.findDrive(this.destNode);
            linksCreated = 0;
            iterator = this.srcNodes.iterator();
        } else {
            throw new CloudFileActionException("Destination not writtable.", new ApplicationMessage("CloudFile.msg.DestinationNotWrittable", (Object[])this.emptyParams));
        }
        while (iterator.hasNext()) {
            Node srcNode = iterator.next();
            CloudDrive srcLocal = driveService.findDrive(srcNode);
            String srcPath = srcNode.getPath();
            if (!this.destPath.startsWith(srcPath) && srcLocal != null && srcLocal.isDrive(srcNode)) {
                throw new CloudFileActionException("Copy or move of cloud drive not supported: " + srcPath + " to " + this.destPath, new ApplicationMessage("CloudFile.msg.CloudDriveCopyMoveNotSupported", null, 1));
            }
            if (destLocal == null) {
                if (srcLocal == null || linkManager.isLink((Item)srcNode)) continue;
                if (this.move) {
                    if (!srcLocal.hasFile(srcPath)) continue;
                    throw new CloudFileActionException("Move of cloud file to outside the cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.MoveToOutsideDriveNotSupported", null, 1));
                }
                String srcWorkspace = srcNode.getSession().getWorkspace().getName();
                if (!srcWorkspace.equals(this.destWorkspace)) {
                    throw new CloudFileActionException("Linking between workspaces not supported for Cloud Drive files. " + srcWorkspace + ":" + srcPath + " -> " + this.destWorkspace + ":" + this.destPath, new ApplicationMessage("CloudFile.msg.MoveBetweenWorkspacesNotSupported", null, 1));
                }
                if (groupId != null && destSpace != null) {
                    IShareDocumentService shareService = (IShareDocumentService)WCMCoreUtils.getService(IShareDocumentService.class);
                    shareService.publishDocumentToSpace(groupId, srcNode, "", "read");
                    try {
                        String sharedFolderPath = documentsDrive.getHomePath() + "/Shared";
                        NodeIterator niter = actions.getCloudFileLinks(srcNode, groupId, true);
                        while (niter.hasNext()) {
                            Node link = niter.nextNode();
                            if (!link.getParent().getPath().equals(sharedFolderPath)) continue;
                            Session sysSession = link.getSession();
                            sysSession.refresh(true);
                            try {
                                sysSession.move(link.getPath(), this.destNode.getPath() + "/" + link.getName());
                                sysSession.save();
                                break;
                            }
                            catch (ItemExistsException e) {
                                throw new CloudFileActionException("Cannot move pasted Cloud File to a destination. " + srcWorkspace + ":" + srcPath + " -> " + this.destWorkspace + ":" + this.destPath, new ApplicationMessage("CloudFile.msg.DestinationItemNameExists", null, 0), e);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new CloudFileActionException("Error moving pasted Cloud File to a destination. " + srcWorkspace + ":" + srcPath + " -> " + this.destWorkspace + ":" + this.destPath, new ApplicationMessage("CloudFile.msg.ErrorMoveToDestination", null, 0), e);
                    }
                    ++linksCreated;
                    continue;
                }
                throw new CloudFileActionException("Linking to not space groups not supported for Cloud Drive files. " + srcWorkspace + ":" + srcPath + " -> " + this.destWorkspace + ":" + this.destPath, new ApplicationMessage("CloudFile.msg.FileLinksNotSupportedToThisDestination", null, 0));
            }
            if (srcLocal == null) continue;
            if (!srcLocal.equals(destLocal)) {
                throw new CloudFileActionException("Copy or move of cloud file to another cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.MoveToAnotherDriveNotSupported", null, 1));
            }
            if (this.move) continue;
            new CloudDriveManager(destLocal).initCopy(srcNode, this.destNode);
        }
        if (linksCreated <= 0) {
            return false;
        }
        RequestContext rcontext = WebuiRequestContext.getCurrentInstance();
        if (rcontext != null) {
            ApplicationMessage text;
            String multiple = linksCreated > 1 ? "s" : "";
            String destName = actions.documentName(this.destNode);
            ApplicationMessage title = new ApplicationMessage("CloudFile.msg.LinkCreated", (Object[])new String[]{multiple});
            if (destSpace != null) {
                text = new ApplicationMessage("CloudFile.msg.FileLinksSharedInSpace", (Object[])new String[]{multiple, destName, destSpace.getDisplayName()});
            } else if (groupId != null) {
                OrganizationService orgService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
                Group group = orgService.getGroupHandler().findGroupById(groupId);
                text = new ApplicationMessage("CloudFile.msg.FileLinksSharedInGroup", (Object[])new String[]{multiple, destName, group.getGroupName()});
            } else {
                text = new ApplicationMessage("CloudFile.msg.FileLinksCreated", (Object[])new String[]{multiple, destName});
            }
            ResourceBundle res = rcontext.getApplicationResourceBundle();
            title.setResourceBundle(res);
            text.setResourceBundle(res);
            CloudDriveContext.showInfo((RequestContext)rcontext, (String)title.getMessage(), (String)text.getMessage());
        }
        this.destNode.getSession().save();
        return true;
    }

    protected Node getNodeByInfo(String pathInfo, boolean giveTarget) throws Exception {
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(pathInfo);
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + pathInfo + "'");
        }
        String workspace = matcher.group(1);
        String path = matcher.group(2);
        return this.getNodeByPath(workspace, path, giveTarget);
    }

    protected Node getNodeByPath(String workspace, String path, boolean giveTarget) throws Exception {
        Session srcSession = this.uiExplorer.getSessionByWorkspace(workspace);
        return this.uiExplorer.getNodeByPath(path, srcSession, giveTarget);
    }
}

