/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.viewer;

import org.exoplatform.ecm.webui.viewer.AbstractCloudFileViewer;
import org.exoplatform.services.cms.clouddrives.CloudDriveStorage;
import org.exoplatform.services.cms.clouddrives.viewer.ContentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;

@ComponentConfig(template="classpath:groovy/templates/TextViewer.gtmpl")
public class TextViewer
extends AbstractCloudFileViewer {
    protected static final Log LOG = ExoLogger.getLogger(TextViewer.class);
    public static final long MAX_FILE_SIZE = 0x200000L;

    public boolean isWebDocument() {
        String mimeType = this.file.getType();
        return mimeType.startsWith("text/html") || mimeType.startsWith("application/rss+xml") || mimeType.startsWith("application/xhtml");
    }

    public boolean isXmlDocument() {
        String mimeType = this.file.getType();
        return mimeType.startsWith("text/xml") || mimeType.startsWith("application/xml") || mimeType.startsWith("application/") && mimeType.indexOf("+xml") > 0;
    }

    public boolean isFormattedText() {
        String mimeType = this.file.getType();
        return mimeType.startsWith("text/") && this.file.getTypeMode() != null || mimeType.startsWith("application/") && this.file.getTypeMode() != null || mimeType.startsWith("text/x-") || mimeType.startsWith("application/x-sh") || mimeType.startsWith("text/javascript") || mimeType.startsWith("application/javascript") || mimeType.startsWith("text/json") || mimeType.startsWith("application/json");
    }

    public boolean isViewable() {
        boolean res = super.isViewable();
        if (res) {
            try {
                ContentReader content = ((CloudDriveStorage)this.drive).getFileContent(this.file.getId());
                res = content.getLength() <= 0x200000L;
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error getting file content reader for " + this.file.getId() + " " + this.file.getPath()), e);
            }
        }
        return res;
    }
}

