/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.watch;

import groovy.text.GStringTemplateEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.clouddrives.webui.watch.WatchCloudDocumentServiceImpl;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.services.cms.watch.impl.MessageConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class EmailNotifyCloudDocumentListener
implements EventListener {
    private NodeLocation observedNode_;
    public static final String EMAIL_WATCHERS_PROP = "exo:emailWatcher";
    private static final Log LOG = ExoLogger.getLogger((String)EmailNotifyCloudDocumentListener.class.getName());

    public EmailNotifyCloudDocumentListener(Node oNode) {
        this.observedNode_ = NodeLocation.getNodeLocationByNode((Node)oNode);
    }

    public void onEvent(EventIterator arg0) {
        block3: {
            MailService mailService = (MailService)WCMCoreUtils.getService(MailService.class);
            WatchCloudDocumentServiceImpl watchService = (WatchCloudDocumentServiceImpl)WCMCoreUtils.getService(WatchDocumentService.class);
            MessageConfig messageConfig = watchService.getMessageConfig();
            String sender = MailUtils.getSenderName() + "<" + MailUtils.getSenderEmail() + ">";
            messageConfig.setSender(sender);
            try {
                Node node = NodeLocation.getNodeByLocation((NodeLocation)this.observedNode_);
                NodeLocation nodeLocation = node.isNodeType("nt:resource") ? NodeLocation.getNodeLocationByNode((Node)node.getParent()) : this.observedNode_;
                List<String> emailList = this.getEmailList(NodeLocation.getNodeByLocation((NodeLocation)nodeLocation));
                for (String receiver : emailList) {
                    this.notifyUser(receiver, messageConfig, mailService);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Unable to get node location", (Throwable)e);
            }
        }
    }

    private Message createMessage(String receiver, MessageConfig messageConfig) throws Exception {
        Message message = new Message();
        message.setFrom(messageConfig.getSender());
        message.setTo(receiver);
        message.setSubject(messageConfig.getSubject());
        GStringTemplateEngine engine = new GStringTemplateEngine();
        HashMap<String, String> binding = new HashMap<String, String>();
        Query query = new Query();
        query.setEmail(receiver);
        binding.put("user_name", ((User[])((OrganizationService)WCMCoreUtils.getService(OrganizationService.class)).getUserHandler().findUsersByQuery(query).load(0, 1))[0].getFullName());
        Node node = NodeLocation.getNodeByLocation((NodeLocation)this.observedNode_);
        binding.put("doc_title", Utils.getTitle((Node)node));
        binding.put("doc_name", node.getName());
        binding.put("doc_url", this.getViewableLink(node));
        message.setBody(engine.createTemplate(messageConfig.getContent()).make(binding).toString());
        message.setMimeType(messageConfig.getMimeType());
        return message;
    }

    String getViewableLink(Node node) throws Exception {
        return CommonsUtils.getCurrentDomain() + org.exoplatform.wcm.ext.component.activity.listener.Utils.getContentLink((Node)node);
    }

    public List<String> getMemberships() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection<MembershipEntry> memberships = this.getUserMembershipsFromIdentityRegistry(userId);
        if (memberships != null) {
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + ":" + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        IdentityRegistry identityRegistry = (IdentityRegistry)WCMCoreUtils.getService(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        return currentUserIdentity.getMemberships();
    }

    private List<String> getEmailList(Node observedNode) {
        ArrayList<String> emailList;
        block4: {
            emailList = new ArrayList<String>();
            OrganizationService orgService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
            try {
                if (observedNode.hasProperty(EMAIL_WATCHERS_PROP)) {
                    Value[] watcherNames;
                    for (Value value : watcherNames = observedNode.getProperty(EMAIL_WATCHERS_PROP).getValues()) {
                        String userName = value.getString();
                        User user = orgService.getUserHandler().findUserByName(userName);
                        if (user == null) continue;
                        emailList.add(user.getEmail());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return emailList;
    }

    private void notifyUser(String receiver, MessageConfig messageConfig, MailService mailService) {
        block2: {
            try {
                Message message = this.createMessage(receiver, messageConfig);
                mailService.sendMessage(message);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }
}

