/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.notification.plugin;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionNotificationType;
import org.exoplatform.wallet.utils.WalletUtils;

public class WalletReceiverNotificationPlugin
extends BaseNotificationPlugin {
    public WalletReceiverNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return TransactionNotificationType.RECEIVER.getNotificationId();
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        Wallet senderAccountDetail = (Wallet)ctx.value(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        Wallet receiverAccountDetail = (Wallet)ctx.value(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        String symbol = (String)ctx.value(WalletUtils.SYMBOL_PARAMETER);
        String contractAddress = (String)ctx.value(WalletUtils.CONTRACT_ADDRESS_PARAMETER);
        double amount = (Double)ctx.value(WalletUtils.AMOUNT_PARAMETER);
        String message = (String)ctx.value(WalletUtils.MESSAGE_PARAMETER);
        String hash = (String)ctx.value(WalletUtils.HASH_PARAMETER);
        List toList = WalletUtils.getNotificationReceiversUsers((Wallet)receiverAccountDetail, (String)senderAccountDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        Object senderAvatar = senderAccountDetail.getAvatar();
        if (StringUtils.isBlank((CharSequence)senderAvatar)) {
            senderAvatar = "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
        }
        senderAvatar = CommonsUtils.getCurrentDomain() + (String)senderAvatar;
        return NotificationInfo.instance().to(toList).with("contractAddress", contractAddress).with("account_type", receiverAccountDetail.getType()).with("receiver_type", receiverAccountDetail.getType()).with("amount", String.valueOf(amount)).with("symbol", symbol).with("message", message).with("hash", hash).with("avatar", (String)senderAvatar).with("senderUrl", WalletUtils.getPermanentLink((Wallet)senderAccountDetail)).with("receiverUrl", WalletUtils.getPermanentLink((Wallet)receiverAccountDetail)).with("sender", senderAccountDetail.getName()).with("receiver", receiverAccountDetail.getName()).key(this.getKey()).end();
    }
}

