/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl.trax;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.impl.TransformerBase;
import org.exoplatform.services.xml.transform.trax.TRAXTransformer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TRAXTransformerImpl
extends TransformerBase
implements TRAXTransformer {
    protected TransformerHandler tHandler;

    protected Transformer getTransformer() {
        return this.tHandler.getTransformer();
    }

    public TRAXTransformerImpl() throws TransformerConfigurationException {
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.tHandler = saxTFactory.newTransformerHandler();
    }

    public TRAXTransformerImpl(final Source source) throws TransformerConfigurationException {
        final SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            this.tHandler = (TransformerHandler)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<TransformerHandler>(){

                @Override
                public TransformerHandler run() throws Exception {
                    return saxTFactory.newTransformerHandler(source);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public TRAXTransformerImpl(Templates templates) throws TransformerConfigurationException {
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.tHandler = saxTFactory.newTransformerHandler(templates);
    }

    @Override
    protected void internalTransform(Source source) throws TransformerException, NotSupportedIOTypeException, IllegalStateException {
        XMLReader xmlReader = null;
        try {
            xmlReader = TRAXTransformerImpl.getXMLReader();
            if (this.resolvingService != null) {
                xmlReader.setEntityResolver(this.resolvingService.getEntityResolver());
                LOG.debug((Object)"Set entity resolver");
            }
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        xmlReader.setContentHandler(this.tHandler);
        InputSource inputSource = null;
        if (source instanceof DOMSource) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            SAXTransformerFactory.newInstance().newTransformer().transform(source, new StreamResult(outputStream));
            inputSource = new InputSource(new ByteArrayInputStream(outputStream.toByteArray()));
        } else {
            inputSource = SAXSource.sourceToInputSource(source);
        }
        if (inputSource == null) {
            throw new NotSupportedIOTypeException(source);
        }
        try {
            final XMLReader fXMLReader = xmlReader;
            final InputSource fInputSource = inputSource;
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    fXMLReader.parse(fInputSource);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof SAXException) {
                throw new TransformerException(cause);
            }
            if (cause instanceof IOException) {
                throw new TransformerException(cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    protected void afterInitResult() {
        this.tHandler.setResult(this.getResult());
    }

    @Override
    public Result getTransformerAsResult() {
        return new SAXResult(this.tHandler);
    }

    @Override
    public Object getParameter(String param) {
        return this.getTransformer().getParameter(param);
    }

    @Override
    public void setParameter(String name, Object value) {
        this.getTransformer().setParameter(name, value);
    }

    @Override
    public void clearParameters() {
        this.getTransformer().clearParameters();
    }

    @Override
    public String getOutputProperty(String prop) {
        return this.getTransformer().getOutputProperty(prop);
    }

    @Override
    public void setOutputProperty(String name, String value) {
        this.getTransformer().setOutputProperty(name, value);
    }

    @Override
    public void setOutputProperties(Properties props) {
        this.getTransformer().setOutputProperties(props);
    }

    @Override
    public Properties getOutputProperties() {
        return this.getTransformer().getOutputProperties();
    }

    @Override
    public URIResolver getURIResolver() {
        return this.getTransformer().getURIResolver();
    }

    @Override
    public void setURIResolver(URIResolver resolver) {
        this.getTransformer().setURIResolver(resolver);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.getTransformer().getErrorListener();
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.getTransformer().setErrorListener(listener);
    }
}

