/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.wci.security.Credentials;

public class AuthenticationRegistryImpl
implements AuthenticationRegistry {
    private static final Log log = ExoLogger.getLogger(AuthenticationRegistryImpl.class);
    private final ConcurrentMap<String, Map<String, Object>> registry = new ConcurrentHashMap<String, Map<String, Object>>();

    @Override
    public Credentials getCredentials(HttpServletRequest request) {
        return (Credentials)this.getAttributeOfClient(request, "credentials");
    }

    @Override
    public void setCredentials(HttpServletRequest request, Credentials credentials) {
        this.setAttributeOfClient(request, "credentials", credentials);
    }

    @Override
    public Credentials removeCredentials(HttpServletRequest request) {
        return (Credentials)this.removeAttributeOfClient(request, "credentials");
    }

    @Override
    public void removeClient(String sessionId) {
        this.registry.remove(sessionId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Entry cleared for session " + sessionId));
        }
    }

    @Override
    public void setAttributeOfClient(HttpServletRequest request, String attributeName, Object attributeValue) {
        String sessionId = this.getSessionId(request);
        Map<String, Object> attributesOfClient = this.getAllAttributesOfClient(sessionId);
        attributesOfClient.put(attributeName, attributeValue);
    }

    @Override
    public Object getAttributeOfClient(HttpServletRequest request, String attributeName) {
        String sessionId = this.getSessionId(request);
        Map attributesOfClient = (Map)this.registry.get(sessionId);
        if (attributesOfClient == null) {
            return null;
        }
        return attributesOfClient.get(attributeName);
    }

    @Override
    public Object removeAttributeOfClient(HttpServletRequest request, String attributeName) {
        String sessionId = this.getSessionId(request);
        Map<String, Object> attributesOfClient = this.getAllAttributesOfClient(sessionId);
        Object removedAttribute = attributesOfClient.remove(attributeName);
        if (attributesOfClient.size() == 0) {
            this.removeClient(sessionId);
        }
        return removedAttribute;
    }

    private Map<String, Object> getAllAttributesOfClient(String sessionId) {
        ConcurrentHashMap attributes = (ConcurrentHashMap)this.registry.get(sessionId);
        if (attributes == null) {
            attributes = new ConcurrentHashMap();
            this.registry.putIfAbsent(sessionId, attributes);
            if (log.isTraceEnabled()) {
                log.trace((Object)("New entry created in AuthenticationRegistry for session " + sessionId));
            }
        }
        return (Map)this.registry.get(sessionId);
    }

    private String getSessionId(HttpServletRequest req) {
        return req.getSession().getId();
    }
}

