/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.codec;

import java.io.Closeable;
import java.io.FileInputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.KeyStore;
import java.util.Map;
import javax.crypto.SecretKey;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.AbstractCodecBuilder;
import org.exoplatform.web.security.codec.JCASymmetricCodec;
import org.gatein.common.io.IOTools;

public class JCASymmetricCodecBuilder
extends AbstractCodecBuilder {
    @Override
    public final AbstractCodec build(Map<String, String> config) {
        JCASymmetricCodec jCASymmetricCodec;
        String transformation = config.get("gatein.codec.jca.symmetric.keyalg");
        Object keyFile = config.get("gatein.codec.jca.symmetric.keystore");
        String storeType = config.get("gatein.codec.jca.symmetric.storetype");
        String alias = config.get("gatein.codec.jca.symmetric.alias");
        char[] storePass = config.get("gatein.codec.jca.symmetric.storepass").toCharArray();
        char[] keyPass = config.get("gatein.codec.jca.symmetric.keypass").toCharArray();
        FileInputStream in = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            if (!((String)keyFile).startsWith("file:") && config.get("gatein.codec.config.basedir") != null) {
                keyFile = config.get("gatein.codec.config.basedir") + "/" + (String)keyFile;
            }
            in = new FileInputStream((String)keyFile);
            keyStore.load(in, storePass);
            KeyStore.Entry entry = keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPass));
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            jCASymmetricCodec = new JCASymmetricCodec(transformation, secretKey);
        }
        catch (Exception ex) {
            try {
                throw new UndeclaredThrowableException(ex);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(in);
                throw throwable;
            }
        }
        IOTools.safeClose((Closeable)in);
        return jCASymmetricCodec;
    }
}

