/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin.child;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.service.rest.LinkShare;

public class LinkActivityChildPlugin
extends AbstractNotificationChildPlugin {
    public static final ArgumentLiteral<String> ACTIVITY_ID = new ArgumentLiteral(String.class, "activityId");
    public static final String ID = "LINK_ACTIVITY";
    public static final String LINK_PARAM = "link";
    public static final String IMAGE_PARAM = "image";
    public static final String TITLE_PARAM = "title";
    public static final String DESCRIPTION_PARAM = "description";
    public static final String COMMENT_PARAM = "comment";
    public static final String VIEW_FULL_ACTIVITY = "view_full_activity";
    private ExoSocialActivity activity = null;
    private boolean isEmbedLink = false;

    public LinkActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        try {
            ActivityManager activityM = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(ACTIVITY_ID.getKey());
            this.activity = activityM.getActivity(activityId);
            if (this.activity.isComment()) {
                this.activity = activityM.getParentActivity(this.activity);
            }
            TemplateContext templateContext = new TemplateContext(ID, language);
            String url = (String)this.activity.getTemplateParams().get(LINK_PARAM);
            templateContext.put((Object)"ACTIVITY_TITLE", (Object)NotificationUtils.processLinkTitle((String)((String)this.activity.getTemplateParams().get(COMMENT_PARAM))));
            templateContext.put((Object)"LINK_TITLE", (Object)NotificationUtils.processLinkTitle((String)((String)this.activity.getTemplateParams().get(TITLE_PARAM))));
            templateContext.put((Object)"LINK_URL", (Object)url);
            templateContext.put((Object)"THUMBNAIL_URL", (Object)this.getImageUrl(url));
            templateContext.put((Object)"IS_EMBED_LINK", (Object)this.isEmbedLink());
            templateContext.put((Object)"LINK_DESCRIPTION", (Object)Utils.formatContent((String)this.activity.getTemplateParams().get(DESCRIPTION_PARAM)));
            templateContext.put((Object)"ACTIVITY_URL", (Object)LinkProviderUtils.getRedirectUrl(VIEW_FULL_ACTIVITY, this.activity.getId()));
            String content = TemplateUtils.processGroovy((TemplateContext)templateContext);
            return content;
        }
        catch (Exception e) {
            return this.activity != null ? this.activity.getTitle() : "";
        }
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }

    private String getImageUrl(String url) {
        try {
            String imageUrl = (String)this.activity.getTemplateParams().get(IMAGE_PARAM);
            if (imageUrl != null && imageUrl.length() > 0) {
                this.setEmbedLink(false);
                return imageUrl;
            }
            this.setEmbedLink(true);
            imageUrl = LinkShare.getInstance((String)url).getMediaObject().getThumbnailUrl();
            return imageUrl != null ? imageUrl : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isEmbedLink() {
        return this.isEmbedLink;
    }

    public void setEmbedLink(boolean isEmbedLink) {
        this.isEmbedLink = isEmbedLink;
    }
}

