/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.portal.config.model.Version;
import org.gatein.common.io.IOTools;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.impl.UnmarshallingContext;

public class ModelUnmarshaller {
    public static <T> UnmarshalledObject<T> unmarshall(Class<T> type, InputStream in) throws Exception {
        return ModelUnmarshaller.unmarshall(type, IOTools.getBytes((InputStream)in));
    }

    public static <T> UnmarshalledObject<T> unmarshall(Class<T> type, byte[] bytes) throws Exception {
        ByteArrayInputStream baos = new ByteArrayInputStream(bytes);
        IBindingFactory bfact = BindingDirectory.getFactory(type);
        UnmarshallingContext uctx = (UnmarshallingContext)bfact.createUnmarshallingContext();
        uctx.setDocument((InputStream)baos, null, "UTF-8", false);
        T obj = type.cast(uctx.unmarshalElement());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        baos.reset();
        XMLStreamReader reader = factory.createXMLStreamReader(baos);
        Version version = Version.UNKNOWN;
        while (reader.hasNext()) {
            int next = reader.next();
            if (next != 1) continue;
            QName name = reader.getName();
            String uri = name.getNamespaceURI();
            if (uri == null) break;
            version = Version.forURI(uri);
            break;
        }
        return new UnmarshalledObject<T>(version, obj);
    }
}

