/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.List;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;

@XmlType(name="MeasureListType")
public final class MeasureList {
    @XmlValue
    public List<Double> values;
    public Unit<?> unit;

    public MeasureList() {
    }

    public <E> MeasureList(final Object object, Class<E> clazz, Unit<?> unit) {
        this.unit = unit;
        final ObjectConverter objectConverter = ObjectConverters.find(clazz, Double.class);
        this.values = new AbstractList<Double>(){

            @Override
            public int size() {
                return Array.getLength(object);
            }

            @Override
            public Double get(int n) {
                return (Double)objectConverter.apply(Array.get(object, n));
            }
        };
    }

    @XmlAttribute(name="uom", required=true)
    public String getUOM() {
        return Measure.getUOM(this.unit, false, false);
    }

    public void setUOM(String string) throws URISyntaxException {
        Context context = Context.current();
        this.unit = Context.converter(context).toUnit(context, string);
    }

    public double[] toArray() {
        if (this.values == null) {
            return null;
        }
        double[] dArray = new double[this.values.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.values.get(i);
        }
        return dArray;
    }
}

