/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.ObjectStreamException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.opengis.annotation.UML;

final class StandardImplementation
extends MetadataStandard {
    private static final long serialVersionUID = 855786625369724248L;
    private final String implementationPackage;
    private final String[] prefix;
    private final String[] acronyms;
    private final transient Map<Class<?>, Class<?>> implementations;

    StandardImplementation(String string, String string2, String string3, String[] stringArray, String[] stringArray2, MetadataStandard[] metadataStandardArray) {
        super(string, string2, metadataStandardArray);
        this.implementationPackage = string3;
        this.prefix = stringArray;
        this.acronyms = stringArray2;
        this.implementations = new IdentityHashMap();
    }

    @Override
    boolean isPendingAPI(Class<?> clazz) {
        return clazz.getName().startsWith(this.implementationPackage) && clazz.isAnnotationPresent(UML.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Class<? extends T> getImplementation(Class<T> clazz) {
        String string;
        if (clazz != null && clazz.isInterface() && this.isSupported(string = clazz.getName())) {
            Map<Class<?>, Class<?>> map = this.implementations;
            synchronized (map) {
                int n;
                Class<?> clazz2 = this.implementations.get(clazz);
                if (clazz2 != null) {
                    return clazz2 != Void.TYPE ? clazz2.asSubclass(clazz) : null;
                }
                StringBuilder stringBuilder = new StringBuilder(this.implementationPackage).append(string, this.interfacePackage.length(), string.length());
                if (this.acronyms != null) {
                    for (n = 0; n < this.acronyms.length; n += 2) {
                        String string2 = this.acronyms[n];
                        if (!CharSequences.endsWith((CharSequence)stringBuilder, (CharSequence)string2, (boolean)false)) continue;
                        stringBuilder.setLength(stringBuilder.length() - string2.length());
                        stringBuilder.append(this.acronyms[n + 1]);
                        break;
                    }
                }
                n = stringBuilder.lastIndexOf(".") + 1;
                int n2 = 0;
                for (String string3 : this.prefix) {
                    string = stringBuilder.replace(n, n + n2, string3).toString();
                    try {
                        clazz2 = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.metadata"), MetadataStandard.class, (String)"getImplementation", (Throwable)classNotFoundException);
                        n2 = string3.length();
                        continue;
                    }
                    this.implementations.put(clazz, clazz2);
                    return clazz2.asSubclass(clazz);
                }
                this.implementations.put(clazz, Void.TYPE);
            }
        }
        return null;
    }

    Object readResolve() throws ObjectStreamException {
        if (StandardImplementation.ISO_19111.citation.equals((Object)this.citation)) {
            return ISO_19111;
        }
        if (StandardImplementation.ISO_19115.citation.equals((Object)this.citation)) {
            return ISO_19115;
        }
        StandardImplementation.setMapForField(StandardImplementation.class, this, "implementations");
        return this;
    }
}

