/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.TreeFormatCustomization;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.MetadataFormat;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TreeNode;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.metadata.citation.Citation;

final class TreeTableView
implements TreeTable,
TreeFormatCustomization,
Serializable {
    private static final long serialVersionUID = 3911016927808764394L;
    static final List<TableColumn<?>> COLUMNS = UnmodifiableArrayList.wrap((Object[])new TableColumn[]{TableColumn.IDENTIFIER, TableColumn.INDEX, TableColumn.NAME, TableColumn.TYPE, TableColumn.VALUE, TableColumn.REMARKS});
    private transient TreeNode root;
    final MetadataStandard standard;
    final ValueExistencePolicy valuePolicy;

    TreeTableView(MetadataStandard metadataStandard, Object object, Class<?> clazz, ValueExistencePolicy valueExistencePolicy) {
        this.standard = metadataStandard;
        this.valuePolicy = valueExistencePolicy;
        this.root = new TreeNode(this, object, clazz);
    }

    public List<TableColumn<?>> getColumns() {
        return COLUMNS;
    }

    public TreeTable.Node getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean bl = Semaphores.queryAndSet((int)1);
        try {
            MetadataFormat metadataFormat = MetadataFormat.INSTANCE;
            synchronized (metadataFormat) {
                String string = MetadataFormat.INSTANCE.format(this);
                return string;
            }
        }
        finally {
            Semaphores.clear((int)1, (boolean)bl);
        }
    }

    public Predicate<TreeTable.Node> filter() {
        return TreeTableView::filter;
    }

    private static boolean filter(TreeTable.Node node) {
        TreeTable.Node node2 = node.getParent();
        if (node2 instanceof TreeNode && Citation.class.isAssignableFrom(((TreeNode)node2).baseType)) {
            Citation citation;
            Object object = null;
            if (node instanceof TreeNode) {
                object = ((TreeNode)node).cachedValue;
            }
            if (object == null) {
                object = node.getUserObject();
            }
            if (object instanceof SpecializedIdentifier && (citation = ((SpecializedIdentifier)object).getAuthority()) instanceof NonMarshalledAuthority && ((NonMarshalledAuthority)citation).isBookOrSerialNumber()) {
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.root.baseType);
        objectOutputStream.writeObject(this.root.metadata);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Class clazz = (Class)objectInputStream.readObject();
        this.root = new TreeNode(this, objectInputStream.readObject(), clazz);
    }
}

