/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.channel;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.ChannelConfig;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.lifecycle.MailLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@ChannelConfig(lifecycle=MailLifecycle.class)
public final class MailChannel
extends AbstractChannel {
    private static final Log LOG = ExoLogger.getLogger(MailChannel.class);
    public static final String ID = "MAIL_CHANNEL";
    private final ChannelKey key = ChannelKey.key((String)"MAIL_CHANNEL");
    private final Map<PluginKey, String> templateFilePaths = new HashMap<PluginKey, String>();
    private final Map<PluginKey, AbstractTemplateBuilder> templateBuilders = new HashMap<PluginKey, AbstractTemplateBuilder>();

    public MailChannel() {
        super((AbstractNotificationLifecycle)new MailLifecycle());
    }

    public String getId() {
        return ID;
    }

    public ChannelKey getKey() {
        return this.key;
    }

    public void registerTemplateProvider(TemplateProvider provider) {
        this.templateFilePaths.putAll(provider.getTemplateFilePathConfigs());
        this.templateBuilders.putAll(provider.getTemplateBuilder());
    }

    public void dispatch(NotificationContext ctx, String userId) {
        String pluginId = ctx.getNotificationInfo().getKey().getId();
        String templateFilePath = this.templateFilePaths.get(pluginId);
        LOG.debug((Object)("Mail::{ userId:" + userId + ", pluginId: " + pluginId + ", templateFilePath: " + templateFilePath + "}"));
    }

    public String getTemplateFilePath(PluginKey key) {
        return this.templateFilePaths.get(key);
    }

    public boolean hasTemplateBuilder(PluginKey key) {
        AbstractTemplateBuilder builder = this.templateBuilders.get(key);
        return builder != null;
    }

    protected AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey key) {
        return this.templateBuilders.get(key);
    }
}

