/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage.cache.model;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;

public class WebNotifInfoData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private PluginKey key;
    private String from = "";
    private String to;
    private int order;
    private Map<String, String> ownerParameter = new HashMap<String, String>();
    private List<String> sendToUserIds = new ArrayList<String>();
    private String[] sendToDaily;
    private String[] sendToWeekly;
    private long lastModifiedDate;
    private String title = "";
    private ChannelKey channelKey;

    public WebNotifInfoData(NotificationInfo notificationInfo) {
        this.id = notificationInfo.getId();
        this.key = notificationInfo.getKey();
        this.from = notificationInfo.getFrom();
        this.to = notificationInfo.getTo();
        this.order = notificationInfo.getOrder();
        this.ownerParameter = notificationInfo.getOwnerParameter();
        this.sendToUserIds = notificationInfo.getSendToUserIds();
        this.sendToDaily = notificationInfo.getSendToDaily();
        this.sendToWeekly = notificationInfo.getSendToWeekly();
        this.lastModifiedDate = notificationInfo.getLastModifiedDate();
        this.title = notificationInfo.getTitle();
        this.channelKey = notificationInfo.getChannelKey();
    }

    public NotificationInfo build() {
        NotificationInfo notificationInfo = new NotificationInfo();
        notificationInfo.setId(this.id);
        notificationInfo.key(this.key);
        notificationInfo.setFrom(this.from);
        notificationInfo.setTo(this.to);
        notificationInfo.setOrder(this.order);
        notificationInfo.setOwnerParameter(this.ownerParameter);
        notificationInfo.to(this.sendToUserIds);
        notificationInfo.setSendToDaily(this.sendToDaily);
        notificationInfo.setSendToWeekly(this.sendToWeekly);
        notificationInfo.setLastModifiedDate(this.lastModifiedDate);
        notificationInfo.setTitle(this.title);
        notificationInfo.setChannelKey(this.channelKey);
        if (this.ownerParameter != null && this.ownerParameter.containsKey(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey())) {
            notificationInfo.setOnPopOver(Boolean.valueOf(this.ownerParameter.get(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey())).booleanValue());
        }
        if (this.ownerParameter != null && this.ownerParameter.containsKey(NotificationMessageUtils.READ_PORPERTY.getKey())) {
            notificationInfo.setRead(Boolean.valueOf(this.ownerParameter.get(NotificationMessageUtils.READ_PORPERTY.getKey())).booleanValue());
        }
        return notificationInfo;
    }

    public String getTo() {
        return this.to;
    }

    public WebNotifInfoData updateRead(boolean isRead) {
        if (this.ownerParameter == null) {
            this.ownerParameter = new HashMap<String, String>();
        }
        this.ownerParameter.put(NotificationMessageUtils.READ_PORPERTY.getKey(), String.valueOf(isRead));
        return this;
    }

    public WebNotifInfoData updateShowPopover(boolean isShow) {
        if (this.ownerParameter == null) {
            this.ownerParameter = new HashMap<String, String>();
        }
        this.ownerParameter.put(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey(), String.valueOf(isShow));
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("WebNotif{").append("title: ").append(this.title).append("from: ").append(this.from).append("to: ").append(this.to).append("channelKey: ").append(this.channelKey).append(", showPopover: ").append(this.ownerParameter.get(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebNotifInfoData that = (WebNotifInfoData)o;
        return this.order == that.order && this.lastModifiedDate == that.lastModifiedDate && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.from, (Object)that.from) && Objects.equal((Object)this.to, (Object)that.to) && Objects.equal(this.ownerParameter, that.ownerParameter) && Objects.equal(this.sendToUserIds, that.sendToUserIds) && Objects.equal((Object)this.sendToDaily, (Object)that.sendToDaily) && Objects.equal((Object)this.sendToWeekly, (Object)that.sendToWeekly) && Objects.equal((Object)this.title, (Object)that.title) && Objects.equal((Object)this.channelKey, (Object)that.channelKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.key, this.from, this.to, this.order, this.ownerParameter, this.sendToUserIds, this.sendToDaily, this.sendToWeekly, this.lastModifiedDate, this.title, this.channelKey});
    }
}

