/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;

public abstract class AccessManager {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.AccessManager");
    protected final Map<String, String> parameters = new HashMap<String, String>();
    private static ThreadLocal<InvocationContext> contextHolder = new ThreadLocal();

    protected AccessManager(RepositoryEntry config, WorkspaceEntry wsConfig) throws RepositoryException {
        if (wsConfig != null && wsConfig.getAccessManager() != null) {
            Collection<SimpleParameterEntry> paramList = wsConfig.getAccessManager().getParameters();
            for (SimpleParameterEntry param : paramList) {
                this.parameters.put(param.getName(), param.getValue());
            }
        }
    }

    protected final InvocationContext context() {
        return contextHolder.get();
    }

    public final void setContext(InvocationContext context) {
        contextHolder.set(context);
    }

    public final boolean hasPermission(AccessControlList acl, String permission, Identity user) throws RepositoryException {
        return this.hasPermission(acl, AccessManager.parseStringPermissions(permission), user);
    }

    public boolean hasPermission(AccessControlList acl, String[] permission, Identity user) {
        String userId = user.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (userId.equals(acl.getOwner())) {
            return true;
        }
        if (userId.equals(IdentityConstants.ANONIM)) {
            List<String> anyPermissions = acl.getPermissions(IdentityConstants.ANY);
            if (anyPermissions.size() < permission.length) {
                return false;
            }
            for (int i = 0; i < permission.length; ++i) {
                if (anyPermissions.contains(permission[i])) continue;
                return false;
            }
            return true;
        }
        if (acl.getPermissionsSize() > 0 && permission.length > 0) {
            for (int i = 0; i < permission.length; ++i) {
                if (this.isPermissionMatch(acl.getPermissionsList(), permission[i], user)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String[] parseStringPermissions(String str) throws RepositoryException {
        int index;
        ArrayList<String> permissions = new ArrayList<String>();
        int fromIndex = 0;
        do {
            String token = (index = str.indexOf(44, fromIndex)) == -1 ? str.substring(fromIndex) : str.substring(fromIndex, index);
            token = token.trim();
            fromIndex = index + 1;
            if (token.isEmpty()) continue;
            if ("read".equals(token) || "add_node".equals(token) || "remove".equals(token) || "set_property".equals(token)) {
                permissions.add(token);
                continue;
            }
            throw new RepositoryException("Unknown permission entry " + token);
        } while (index != -1);
        return permissions.toArray(new String[permissions.size()]);
    }

    private boolean isPermissionMatch(List<AccessControlEntry> existedPermission, String testPermission, Identity user) {
        int length = existedPermission.size();
        for (int i = 0; i < length; ++i) {
            AccessControlEntry ace = existedPermission.get(i);
            if (!ace.getPermission().equals(testPermission)) continue;
            if (ace.getIdentity().equals(IdentityConstants.ANY)) {
                return true;
            }
            if (!(ace.getIdentity().indexOf(":") == -1 ? ace.getIdentity().equals(user.getUserId()) : user.isMemberOf(ace.getMembershipEntry()))) continue;
            return true;
        }
        return false;
    }
}

