/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectWriter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBBackup {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBBackup");
    public static final String CONTENT_FILE_SUFFIX = ".dump";
    public static final String CONTENT_LEN_FILE_SUFFIX = ".len";
    public static final String CONTENT_ZIP_FILE = "dump.zip";
    public static final String CONTENT_LEN_ZIP_FILE = "dump-len.zip";
    private static final String FULL_BACKUP_JOB_FETCH_SIZE = "exo.jcr.component.ext.FullBackupJob.fetch-size";
    private static final int FETCH_SIZE;

    public static void backup(File storageDir, Connection jdbcConn, Map<String, String> scripts) throws BackupException {
        Exception exc = null;
        ObjectWriterImpl contentWriter = null;
        ObjectWriterImpl contentLenWriter = null;
        try {
            contentWriter = new ZipObjectWriter(PrivilegedFileHelper.zipOutputStream((File)new File(storageDir, CONTENT_ZIP_FILE)));
            contentLenWriter = new ZipObjectWriter(PrivilegedFileHelper.zipOutputStream((File)new File(storageDir, CONTENT_LEN_ZIP_FILE)));
            for (Map.Entry<String, String> entry : scripts.entrySet()) {
                DBBackup.dumpTable(jdbcConn, entry.getKey(), entry.getValue(), storageDir, (ZipObjectWriter)contentWriter, (ZipObjectWriter)contentLenWriter);
            }
        }
        catch (IOException e) {
            exc = e;
            throw new BackupException(e);
        }
        catch (SQLException e) {
            exc = e;
            throw new BackupException("SQL Exception: " + JDBCUtils.getFullMessage((SQLException)e), e);
        }
        finally {
            if (jdbcConn != null) {
                try {
                    jdbcConn.close();
                }
                catch (SQLException e) {
                    if (exc != null) {
                        LOG.error((Object)"Can't close connection", (Throwable)e);
                        throw new BackupException(exc);
                    }
                    throw new BackupException(e);
                }
            }
            try {
                if (contentWriter != null) {
                    contentWriter.close();
                }
                if (contentLenWriter != null) {
                    contentLenWriter.close();
                }
            }
            catch (IOException e) {
                if (exc != null) {
                    LOG.error((Object)"Can't close zip", (Throwable)e);
                    throw new BackupException(exc);
                }
                throw new BackupException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpTable(Connection jdbcConn, String tableName, String script, File storageDir, ZipObjectWriter contentWriter, ZipObjectWriter contentLenWriter) throws IOException, SQLException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            contentWriter.putNextEntry(new ZipEntry(tableName));
            contentLenWriter.putNextEntry(new ZipEntry(tableName));
            stmt = jdbcConn.createStatement(1003, 1007);
            stmt.setFetchSize(FETCH_SIZE);
            rs = stmt.executeQuery(script);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            int[] columnType = new int[columnCount];
            contentWriter.writeInt(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                columnType[i] = metaData.getColumnType(i + 1);
                contentWriter.writeInt(columnType[i]);
                contentWriter.writeString(metaData.getColumnName(i + 1));
            }
            byte[] tmpBuff = new byte[2048];
            while (rs.next()) {
                for (int i = 0; i < columnCount; ++i) {
                    InputStream value;
                    if (columnType[i] == -3 || columnType[i] == -4 || columnType[i] == 2004 || columnType[i] == -2 || columnType[i] == 1111) {
                        value = rs.getBinaryStream(i + 1);
                    } else {
                        String str = rs.getString(i + 1);
                        InputStream inputStream = value = str == null ? null : new ByteArrayInputStream(str.getBytes("UTF-8"));
                    }
                    if (value == null) {
                        contentLenWriter.writeLong(-1L);
                        continue;
                    }
                    long len = 0L;
                    int read = 0;
                    while ((read = value.read(tmpBuff)) >= 0) {
                        contentWriter.write(tmpBuff, 0, read);
                        len += (long)read;
                    }
                    contentLenWriter.writeLong(len);
                }
            }
            contentWriter.closeEntry();
            contentLenWriter.closeEntry();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    static {
        String size = PropertyManager.getProperty((String)FULL_BACKUP_JOB_FETCH_SIZE);
        int value = 1000;
        if (size != null) {
            try {
                value = Integer.valueOf(size);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"The value of the property 'exo.jcr.component.ext.FullBackupJob.fetch-size' must be an integer, the default value will be used.");
            }
        }
        FETCH_SIZE = value;
    }
}

