/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.AbstractRepositorySuspender;
import org.exoplatform.services.jcr.impl.checker.InspectionReport;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.AbstractCacheableLockManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainerChecker;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositoryCheckController")})
public class RepositoryCheckController
extends AbstractRepositorySuspender
implements Startable {
    protected static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryCheckController");
    public static final String REPORT_CONSISTENT_MESSAGE = "Repository data is consistent";
    public static final String REPORT_NOT_CONSISTENT_MESSAGE = "Repository data is NOT consistent";
    public static final String EXCEPTION_DURING_CHECKING_MESSAGE = "Exception occured during consistency checking";
    public static final String CONFIRMATION_FAILED_MESSAGE = "For starting auto-repair function please enter \"YES\" as method parameter";
    protected InspectionReport lastReport;

    public RepositoryCheckController(ManageableRepository repository) {
        super(repository);
    }

    @Managed
    @ManagedDescription(value="Check repository data consistency. DB data, value storage and lucene index will be checked.")
    public String checkAll() {
        return this.checkAll(1);
    }

    @Managed
    @ManagedDescription(value="Check repository data consistency. DB data, value storage and lucene index will be checked. Set nThreads parameter to configure the number of threads.")
    public String checkAll(@ManagedName(value="nThreads") int nThreads) {
        return this.checkAndRepair(new DataStorage[]{DataStorage.DB, DataStorage.VALUE_STORAGE, DataStorage.LUCENE_INDEX}, false, nThreads);
    }

    @Managed
    @ManagedDescription(value="Check repository database consistency.")
    public String checkDataBase() {
        return this.checkDataBase(1);
    }

    @Managed
    @ManagedDescription(value="Check repository database consistency. Set nThreads parameter to configure the number of threads.")
    public String checkDataBase(@ManagedName(value="nThreads") int nThreads) {
        return this.checkAndRepair(new DataStorage[]{DataStorage.DB}, false, nThreads);
    }

    @Managed
    @ManagedDescription(value="Check repository value storage consistency.")
    public String checkValueStorage() {
        return this.checkValueStorage(1);
    }

    @Managed
    @ManagedDescription(value="Check repository value storage consistency. Set nThreads parameter to configure the number of threads")
    public String checkValueStorage(@ManagedName(value="nThreads") int nThreads) {
        return this.checkAndRepair(new DataStorage[]{DataStorage.VALUE_STORAGE}, false, nThreads);
    }

    @Managed
    @ManagedDescription(value="Check repository search index consistency.")
    public String checkIndex() {
        return this.checkIndex(1);
    }

    @Managed
    @ManagedDescription(value="Check repository search index consistency. Set nThreads parameter to configure the number of threads")
    public String checkIndex(@ManagedName(value="nThreads") int nThreads) {
        return this.checkAndRepair(new DataStorage[]{DataStorage.LUCENE_INDEX}, false, nThreads);
    }

    @Managed
    @ManagedDescription(value="Auto-repair inconsistencies for value storage. Don't forget to backup your data first. Set confirmation parameter to \"YES\" for enabling auto-repair feature.")
    public String repairValueStorage(@ManagedName(value="confirmation") String confirmation) {
        return this.repairValueStorage(confirmation, 1);
    }

    @Managed
    @ManagedDescription(value="Auto-repair inconsistencies for value storage. Don't forget to backup your data first. Set confirmation parameter to \"YES\" for enabling auto-repair feature. Set nThreads parameter to configure the number of threads")
    public String repairValueStorage(@ManagedName(value="confirmation") String confirmation, @ManagedName(value="nThreads") int nThreads) {
        if (confirmation.equalsIgnoreCase("YES")) {
            return this.checkAndRepair(new DataStorage[]{DataStorage.VALUE_STORAGE}, true, nThreads);
        }
        return CONFIRMATION_FAILED_MESSAGE;
    }

    @Managed
    @ManagedDescription(value="Auto-repair inconsistencies for database. Don't forget to backup your data first. Set confirmation parameter to \"YES\" for enabling auto-repair feature.")
    public String repairDataBase(@ManagedName(value="confirmation") String confirmation) {
        return this.repairDataBase(confirmation, 1);
    }

    @Managed
    @ManagedDescription(value="Auto-repair inconsistencies for database. Don't forget to backup your data first. Set confirmation parameter to \"YES\" for enabling auto-repair feature. Set nThreads parameter to configure the number of threads.")
    public String repairDataBase(@ManagedName(value="confirmation") String confirmation, @ManagedName(value="nThreads") int nThreads) {
        if (confirmation.equalsIgnoreCase("YES")) {
            return this.checkAndRepair(new DataStorage[]{DataStorage.DB}, true, nThreads);
        }
        return CONFIRMATION_FAILED_MESSAGE;
    }

    public String checkAndRepair(final DataStorage[] storages, final boolean autoRepair, final int nThreads) {
        return (String)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<String>(){

            @Override
            public String run() {
                return RepositoryCheckController.this.checkAndRepairAction(storages, autoRepair, nThreads);
            }
        });
    }

    public String getLastReportPath() {
        return this.lastReport != null ? this.lastReport.getReportPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String checkAndRepairAction(DataStorage[] storages, boolean autoRepair, int nThreads) {
        try {
            this.createNewReport();
        }
        catch (IOException e) {
            return this.getExceptionDuringCheckingMessage(e);
        }
        try {
            this.suspendRepository();
            if (nThreads > 1) {
                try {
                    MultithreadedChecking checking = new MultithreadedChecking(storages, autoRepair, nThreads);
                    String string = checking.startThreads();
                    return string;
                }
                catch (IOException e) {
                    String string = this.getExceptionDuringCheckingMessage(e);
                    this.resumeRepository();
                    this.closeReport();
                    return string;
                }
            }
            this.lastReport.init(false);
            String e = this.doCheckAndRepair(storages, autoRepair);
            return e;
            {
                catch (RepositoryException e2) {
                    String string = this.getExceptionDuringCheckingMessage(e2);
                    return string;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resumeRepository();
            this.closeReport();
        }
    }

    @Override
    protected void resumeRepository() {
        try {
            super.resumeRepository();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), (Throwable)e);
        }
    }

    private String doCheckAndRepair(DataStorage[] storages, boolean autoRepair) {
        try {
            this.doCheckAndRepair(storages, autoRepair, null);
            return this.logAndGetCheckingResultMessage();
        }
        catch (Throwable e) {
            return this.logAndGetExceptionDuringCheckingMessage(e);
        }
    }

    private void doCheckAndRepair(DataStorage[] storages, boolean autoRepair, Queue<Callable<Void>> tasks) throws IOException, RepositoryException {
        block5: for (DataStorage storage : storages) {
            switch (storage) {
                case DB: {
                    this.doCheckDataBase(autoRepair, tasks);
                    continue block5;
                }
                case VALUE_STORAGE: {
                    this.doCheckValueStorage(autoRepair, tasks);
                    continue block5;
                }
                case LUCENE_INDEX: {
                    this.doCheckIndex(autoRepair, tasks);
                }
            }
        }
    }

    private String logAndGetCheckingResultMessage() {
        if (this.lastReport.hasInconsistency()) {
            this.logComment(REPORT_NOT_CONSISTENT_MESSAGE);
            return REPORT_NOT_CONSISTENT_MESSAGE + this.getPathToReportMessage();
        }
        this.logComment(REPORT_CONSISTENT_MESSAGE);
        return REPORT_CONSISTENT_MESSAGE + this.getPathToReportMessage();
    }

    private String logAndGetExceptionDuringCheckingMessage(Throwable e) {
        this.logExceptionAndSetInconsistency(EXCEPTION_DURING_CHECKING_MESSAGE, e);
        return this.getExceptionDuringCheckingMessage(e) + this.getPathToReportMessage();
    }

    private String getExceptionDuringCheckingMessage(Throwable e) {
        return "Exception occured during consistency checking: " + e.getMessage();
    }

    private void logComment(String message) {
        try {
            this.lastReport.logComment(message);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void logExceptionAndSetInconsistency(String message, Throwable e) {
        try {
            this.lastReport.logExceptionAndSetInconsistency(message, e);
        }
        catch (IOException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void createNewReport() throws IOException {
        this.lastReport = new InspectionReport(this.repository.getConfiguration().getName());
    }

    private void closeReport() {
        try {
            this.lastReport.close();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void doCheckDataBase(final boolean autoRepair, Queue<Callable<Void>> tasks) throws IOException {
        for (final String wsName : this.repository.getWorkspaceNames()) {
            if (tasks != null) {
                Callable<Void> task = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RepositoryCheckController.this.checkDatabase(autoRepair, wsName);
                        return null;
                    }
                };
                tasks.offer(task);
                continue;
            }
            this.checkDatabase(autoRepair, wsName);
        }
    }

    private void checkDatabase(boolean autoRepair, String wsName) {
        this.logComment("Check DB consistency. Workspace " + wsName);
        JDBCWorkspaceDataContainerChecker jdbcChecker = this.getJDBCChecker(wsName);
        jdbcChecker.checkDataBase(autoRepair);
        jdbcChecker.checkLocksInDataBase(autoRepair);
    }

    private void doCheckValueStorage(final boolean autoRepair, Queue<Callable<Void>> tasks) throws IOException {
        for (final String wsName : this.repository.getWorkspaceNames()) {
            if (tasks != null) {
                Callable<Void> task = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RepositoryCheckController.this.checkValueStorage(autoRepair, wsName);
                        return null;
                    }
                };
                tasks.offer(task);
                continue;
            }
            this.checkValueStorage(autoRepair, wsName);
        }
    }

    private void checkValueStorage(boolean autoRepair, String wsName) {
        this.logComment("Check ValueStorage consistency. Workspace " + wsName);
        this.getJDBCChecker(wsName).checkValueStorage(autoRepair);
    }

    private void doCheckIndex(boolean autoRepair, Queue<Callable<Void>> tasks) throws RepositoryException, IOException {
        for (final String wsName : this.repository.getWorkspaceNames()) {
            if (tasks != null) {
                Callable<Void> task = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RepositoryCheckController.this.checkIndex(wsName);
                        return null;
                    }
                };
                tasks.offer(task);
                continue;
            }
            this.checkIndex(wsName);
        }
    }

    private void checkIndex(String wsName) throws IOException, RepositoryException {
        String systemWS = this.repository.getConfiguration().getSystemWorkspaceName();
        this.logComment("Check SearchIndex consistency. Workspace " + wsName);
        SearchManager searchManager = (SearchManager)this.getComponent(SearchManager.class, wsName);
        searchManager.checkIndex(this.lastReport, systemWS.equals(wsName));
    }

    private JDBCWorkspaceDataContainerChecker getJDBCChecker(String wsName) {
        JDBCWorkspaceDataContainer dataContainer = (JDBCWorkspaceDataContainer)this.getComponent(JDBCWorkspaceDataContainer.class, wsName);
        AbstractCacheableLockManager lockManager = (AbstractCacheableLockManager)this.getComponent(AbstractCacheableLockManager.class, wsName);
        ValueStoragePluginProvider vsPlugin = (ValueStoragePluginProvider)this.getComponent(ValueStoragePluginProvider.class, wsName);
        WorkspaceEntry wsEntry = (WorkspaceEntry)this.getComponent(WorkspaceEntry.class, wsName);
        NodeTypeDataManagerImpl nodeTypeManager = (NodeTypeDataManagerImpl)this.getComponent(NodeTypeDataManagerImpl.class, wsName);
        return new JDBCWorkspaceDataContainerChecker(dataContainer, lockManager, vsPlugin, wsEntry, nodeTypeManager, this.lastReport);
    }

    private Object getComponent(Class forClass, String wsName) {
        return this.repository.getWorkspaceContainer(wsName).getComponent(forClass);
    }

    private String getPathToReportMessage() {
        return ". See full report by path " + this.lastReport.getReportPath();
    }

    public void start() {
    }

    public void stop() {
    }

    public static enum DataStorage {
        DB,
        VALUE_STORAGE,
        LUCENE_INDEX;

    }

    private class MultithreadedChecking {
        private final AtomicInteger runningThreads = new AtomicInteger();
        private final CountDownLatch endSignal;
        private final Thread[] allCheckingThreads;
        private Queue<Callable<Void>> tasks;
        private final Runnable checkingTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    Callable<Void> task;
                    while ((task = MultithreadedChecking.this.tasks.poll()) != null) {
                        try {
                            RepositoryCheckController.this.lastReport.init(true);
                            task.call();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            RepositoryCheckController.this.logAndGetExceptionDuringCheckingMessage(e);
                        }
                        finally {
                            try {
                                RepositoryCheckController.this.lastReport.flush();
                            }
                            catch (IOException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                            AtomicInteger e = MultithreadedChecking.this.runningThreads;
                            synchronized (e) {
                                MultithreadedChecking.this.runningThreads.decrementAndGet();
                                MultithreadedChecking.this.runningThreads.notifyAll();
                            }
                        }
                    }
                    AtomicInteger atomicInteger = MultithreadedChecking.this.runningThreads;
                    synchronized (atomicInteger) {
                        if (!Thread.currentThread().isInterrupted() && MultithreadedChecking.this.runningThreads.get() > 0) {
                            try {
                                MultithreadedChecking.this.runningThreads.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        } else {
                            break;
                        }
                    }
                }
                MultithreadedChecking.this.endSignal.countDown();
            }
        };

        public MultithreadedChecking(DataStorage[] storages, boolean autoRepair, int nThreads) throws IOException, RepositoryException {
            this.endSignal = new CountDownLatch(nThreads);
            this.allCheckingThreads = new Thread[nThreads];
            this.tasks = new LinkedBlockingQueue<Callable<Void>>(){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Callable<Void> poll() {
                    Callable task;
                    AtomicInteger atomicInteger = MultithreadedChecking.this.runningThreads;
                    synchronized (atomicInteger) {
                        task = (Callable)super.poll();
                        if (task != null) {
                            MultithreadedChecking.this.runningThreads.incrementAndGet();
                        }
                    }
                    return task;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean offer(Callable<Void> o) {
                    if (super.offer(o)) {
                        AtomicInteger atomicInteger = MultithreadedChecking.this.runningThreads;
                        synchronized (atomicInteger) {
                            MultithreadedChecking.this.runningThreads.notifyAll();
                        }
                        return true;
                    }
                    return false;
                }
            };
            RepositoryCheckController.this.doCheckAndRepair(storages, autoRepair, this.tasks);
        }

        public String startThreads() throws IOException, RepositoryException {
            for (int i = 0; i < this.allCheckingThreads.length; ++i) {
                this.allCheckingThreads[i] = new Thread(this.checkingTask, "checking Thread #" + (i + 1));
                this.allCheckingThreads[i].start();
            }
            try {
                this.endSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return RepositoryCheckController.this.logAndGetExceptionDuringCheckingMessage(e);
            }
            return RepositoryCheckController.this.logAndGetCheckingResultMessage();
        }
    }
}

