/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;

public class IndexingTree {
    private final QPath indexingRootQpath;
    private final NodeData indexingRoot;
    private final QPath excludedPath;
    private final boolean allIndexing;

    public IndexingTree(NodeData indexingRoot, QPath excludedPath) {
        this.indexingRoot = indexingRoot;
        this.indexingRootQpath = indexingRoot.getQPath();
        this.excludedPath = excludedPath;
        this.allIndexing = indexingRoot.getQPath().getDepth() == 0;
    }

    public NodeData getIndexingRoot() {
        return this.indexingRoot;
    }

    public boolean isExcluded(ItemState event) {
        return this.isExcluded(event.getData());
    }

    public boolean isExcluded(ItemData eventData) {
        if (this.excludedPath != null && (eventData.getQPath().isDescendantOf(this.excludedPath) || eventData.getQPath().equals(this.excludedPath))) {
            return true;
        }
        return !this.allIndexing && !eventData.getQPath().isDescendantOf(this.indexingRootQpath) && !eventData.getQPath().equals(this.indexingRootQpath);
    }
}

