/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.Date;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.query.NAryQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryConstants;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

public class RelationQueryNode
extends NAryQueryNode
implements QueryConstants {
    public static final InternalQName STAR_NAME_TEST = new InternalQName("internal", "__star__");
    private QPath relPath;
    private boolean unaryMinus;
    private long valueLong;
    private int valuePosition;
    private double valueDouble;
    private String valueString;
    private Date valueDate;
    private final int operation;
    private int type;

    protected RelationQueryNode(QueryNode parent, int operation) {
        super(parent);
        this.operation = operation;
    }

    @Override
    public Object accept(QueryNodeVisitor visitor, Object data) throws RepositoryException {
        return visitor.visit(this, data);
    }

    @Override
    public int getType() {
        return 2;
    }

    public void setUnaryMinus(boolean b) {
        this.unaryMinus = b;
    }

    public int getValueType() {
        return this.type;
    }

    public QPath getRelativePath() {
        return this.relPath;
    }

    public void setRelativePath(QPath relPath) {
        if (relPath != null && relPath.isAbsolute()) {
            throw new IllegalArgumentException("relPath must be relative");
        }
        this.relPath = relPath;
    }

    public void addPathElement(QPathEntry element) {
        this.relPath = this.relPath == null ? new QPath(new QPathEntry[]{element}) : QPath.makeChildPath(this.relPath, element, element.getIndex());
    }

    public long getLongValue() {
        return this.valueLong;
    }

    public void setLongValue(long value) {
        this.valueLong = this.unaryMinus ? -value : value;
        this.type = 1;
    }

    public int getPositionValue() {
        return this.valuePosition;
    }

    public void setPositionValue(int value) {
        this.valuePosition = value;
        this.type = 6;
    }

    public double getDoubleValue() {
        return this.valueDouble;
    }

    public void setDoubleValue(double value) {
        this.valueDouble = this.unaryMinus ? -value : value;
        this.type = 2;
    }

    public String getStringValue() {
        return this.valueString;
    }

    public void setStringValue(String value) {
        this.valueString = value;
        this.type = 3;
    }

    public Date getDateValue() {
        return this.valueDate;
    }

    public void setDateValue(Date value) {
        this.valueDate = value;
        this.type = 4;
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RelationQueryNode) {
            RelationQueryNode other = (RelationQueryNode)obj;
            return this.type == other.type && (this.valueDate == null ? other.valueDate == null : this.valueDate.equals(other.valueDate)) && this.valueDouble == other.valueDouble && this.valueLong == other.valueLong && this.valuePosition == other.valuePosition && (this.valueString == null ? other.valueString == null : this.valueString.equals(other.valueString)) && (this.relPath == null ? other.relPath == null : this.relPath.equals(other.relPath));
        }
        return false;
    }
}

