/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.ReaderUtil;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.backup.rdbms.DirectoryRestore;
import org.exoplatform.services.jcr.impl.checker.InspectionReport;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.DefaultChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexException;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.IndexRecoveryImpl;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.LocalIndexMarker;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineIOException;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineRepositoryException;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneVirtualTableResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="SearchManager")})
public class SearchManager
implements Startable,
MandatoryItemsPersistenceListener,
Suspendable,
Backupable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SearchManager");
    private static final DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected final QueryHandlerEntry config;
    protected final DocumentReaderService extractor;
    protected QueryHandler handler;
    protected final ItemDataConsumer itemMgr;
    protected final NamespaceRegistryImpl nsReg;
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final SearchManager parentSearchManager;
    protected IndexingTree indexingTree;
    private final ConfigurationManager cfm;
    protected LuceneVirtualTableResolver virtualTableResolver;
    protected IndexerChangesFilter changesFilter;
    protected final FileCleanerHolder cleanerHolder;
    protected final String repositoryName;
    protected final String workspaceName;
    protected final boolean isSystem;
    protected final RepositoryService rService;
    protected final String wsId;
    protected final boolean enableRemoteCalls;
    protected final String wsContainerId;
    protected final RPCService rpcService;
    protected final AtomicBoolean isSuspended = new AtomicBoolean(false);
    protected final AtomicBoolean isResponsibleForResuming = new AtomicBoolean(false);
    private RemoteCommand suspend;
    private RemoteCommand resume;
    private final IndexRecovery indexRecovery;
    private RemoteCommand requestForResponsibleForResuming;
    private RemoteCommand changeIndexState;
    private final ExoContainerContext ctx;
    private String hotReindexingState = "not stated";
    private final String SUFFIX_ASYNC_REINDEXING = "-async-reindexing";
    private static final String LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT = "org.apache.lucene.maxClauseCount";

    public SearchManager(ExoContainerContext ctx, WorkspaceEntry wEntry, RepositoryEntry rEntry, RepositoryService rService, QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder, FileCleanerHolder cleanerHolder) throws RepositoryException, RepositoryConfigurationException {
        this(ctx, wEntry, rEntry, rService, config, nsReg, ntReg, itemMgr, parentSearchManager, extractor, cfm, indexSearcherHolder, null, cleanerHolder);
    }

    public SearchManager(ExoContainerContext ctx, WorkspaceEntry wEntry, RepositoryEntry rEntry, RepositoryService rService, QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm, RepositoryIndexSearcherHolder indexSearcherHolder, RPCService rpcService, FileCleanerHolder cleanerHolder) throws RepositoryException, RepositoryConfigurationException {
        this.ctx = ctx;
        this.wsContainerId = ctx.getName();
        this.rpcService = rpcService;
        this.repositoryName = rEntry.getName();
        this.workspaceName = wEntry.getName();
        this.isSystem = rEntry.getSystemWorkspaceName().equals(this.workspaceName);
        this.rService = rService;
        this.wsId = wEntry.getUniqueName();
        this.extractor = extractor;
        this.cleanerHolder = cleanerHolder;
        indexSearcherHolder.addIndexSearcher(this);
        this.config = config;
        this.nodeTypeDataManager = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.cfm = cfm;
        this.virtualTableResolver = new LuceneVirtualTableResolver(this.nodeTypeDataManager, nsReg);
        this.parentSearchManager = parentSearchManager != null ? parentSearchManager.get() : null;
        this.enableRemoteCalls = wEntry.getContainer().getParameterBoolean("enable-rpc-sync", false);
        if (parentSearchManager != null) {
            ((WorkspacePersistentDataManager)this.itemMgr).addItemPersistenceListener(this);
        }
        if (rpcService == null) {
            this.indexRecovery = null;
        } else {
            this.initRemoteCommands();
            this.indexRecovery = new IndexRecoveryImpl(rpcService, this);
        }
    }

    public void createNewOrAdd(String key, ItemState state, Map<String, List<ItemState>> updatedNodes) {
        List<ItemState> list = updatedNodes.get(key);
        if (list == null) {
            list = new ArrayList<ItemState>();
            updatedNodes.put(key, list);
        }
        list.add(state);
    }

    public javax.jcr.query.Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, node);
        return query;
    }

    public javax.jcr.query.Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, statement, language);
        return query;
    }

    public void checkIndex(final InspectionReport report, final boolean isSystem) throws RepositoryException, IOException {
        if (this.isSuspended.get()) {
            try {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws RepositoryException, IOException {
                        try {
                            if (isSystem && SearchManager.this.parentSearchManager != null && SearchManager.this.parentSearchManager.isSuspended.get()) {
                                SearchManager.this.parentSearchManager.resume();
                            }
                            SearchManager.this.resume();
                            SearchManager.this.handler.checkIndex(SearchManager.this.itemMgr, isSystem, report);
                            Object var1_1 = null;
                            return var1_1;
                        }
                        catch (ResumeException e) {
                            throw new RepositoryException("Can not resume SearchManager for inspection purposes.", (Throwable)e);
                        }
                        finally {
                            try {
                                SearchManager.this.suspend();
                                if (isSystem && SearchManager.this.parentSearchManager != null && !SearchManager.this.parentSearchManager.isSuspended.get()) {
                                    SearchManager.this.parentSearchManager.suspend();
                                }
                            }
                            catch (SuspendException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable ex = e.getCause();
                if (ex instanceof RepositoryException) {
                    throw (RepositoryException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new RepositoryException(ex.getMessage(), ex);
            }
        } else {
            this.handler.checkIndex(this.itemMgr, isSystem, report);
        }
    }

    public Set<String> getFieldNames() throws IndexException {
        HashSet<String> fildsSet = new HashSet<String>();
        if (this.handler instanceof SearchIndex) {
            IndexReader reader = null;
            try {
                reader = ((SearchIndex)this.handler).getIndexReader();
                FieldInfos infos = ReaderUtil.getMergedFieldInfos((IndexReader)reader);
                for (FieldInfo info : infos) {
                    fildsSet.add(info.name);
                }
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            finally {
                try {
                    if (reader != null) {
                        Util.closeOrRelease(reader);
                    }
                }
                catch (IOException e) {
                    throw new IndexException(e.getLocalizedMessage(), e);
                }
            }
        }
        return fildsSet;
    }

    public QueryHandler getHandler() {
        return this.handler;
    }

    public Set<String> getNodesByNodeType(InternalQName nodeType) throws RepositoryException {
        return this.getNodes(this.virtualTableResolver.resolve(nodeType, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNodesByUri(String uri) throws RepositoryException {
        Set<String> result;
        int defaultClauseCount = BooleanQuery.getMaxClauseCount();
        try {
            ValueFactoryImpl valueFactory = new ValueFactoryImpl(new LocationFactory(this.nsReg), this.cleanerHolder);
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            BooleanQuery query = new BooleanQuery();
            String prefix = this.nsReg.getNamespacePrefixByURI(uri);
            query.add((Query)new WildcardQuery(new Term(FieldNames.LABEL, prefix + ":*")), BooleanClause.Occur.SHOULD);
            query.add((Query)new WildcardQuery(new Term(FieldNames.PROPERTIES_SET, prefix + ":*")), BooleanClause.Occur.SHOULD);
            result = this.getNodes((Query)query);
            try {
                Set<String> props = this.getFieldNames();
                query = new BooleanQuery();
                for (String fieldName : props) {
                    if (FieldNames.PROPERTIES_SET.equals(fieldName)) continue;
                    query.add((Query)new WildcardQuery(new Term(fieldName, "*" + prefix + ":*")), BooleanClause.Occur.SHOULD);
                }
            }
            catch (IndexException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
            Set<String> propSet = this.getNodes((Query)query);
            for (String uuid : propSet) {
                if (!this.isPrefixMatch(valueFactory, uuid, prefix)) continue;
                result.add(uuid);
            }
        }
        finally {
            BooleanQuery.setMaxClauseCount((int)defaultClauseCount);
        }
        return result;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        if (itemStates.getSize() > 0 && this.changesFilter != null && this.parentSearchManager != null) {
            this.changesFilter.onSaveItems(itemStates);
        }
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start");
        }
        try {
            if (this.indexingTree == null) {
                NodeData indexingRootNodeData = (NodeData)this.itemMgr.getItemData("00exo0jcr0root0uuid0000000000000");
                this.indexingTree = new IndexingTree(indexingRootNodeData, this.isSystem ? Constants.JCR_SYSTEM_PATH : null);
            }
            this.initializeQueryHandler();
        }
        catch (RepositoryException e) {
            this.handler = null;
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        catch (RepositoryConfigurationException e) {
            this.handler = null;
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public void stop() {
        this.handler.close();
        if (this.parentSearchManager != null) {
            this.changesFilter.close();
        }
        if (this.indexRecovery != null) {
            this.indexRecovery.close();
        }
        this.unregisterRemoteCommands();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Search manager stopped");
        }
    }

    public void updateIndex(Set<String> removedNodes, Set<String> addedNodes) throws RepositoryException, IOException {
        ChangesHolder changes = this.getChanges(removedNodes, addedNodes);
        this.apply(changes);
    }

    public void apply(ChangesHolder changes) throws RepositoryException, IOException {
        if (!(this.handler == null || changes == null || changes.getAdd().isEmpty() && changes.getRemove().isEmpty())) {
            this.handler.apply(changes);
        }
    }

    public ChangesHolder getChanges(final Set<String> removedNodes, final Set<String> addedNodes) {
        if (this.handler != null) {
            Iterator<NodeData> addedStates = new Iterator<NodeData>(){
                private final Iterator<String> iter;
                {
                    this.iter = addedNodes.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public NodeData next() {
                    do {
                        String id = this.iter.next();
                        try {
                            ItemData item = SearchManager.this.itemMgr.getItemData(id);
                            if (item != null) {
                                if (item.isNode()) {
                                    if (SearchManager.this.indexingTree.isExcluded(item)) continue;
                                    return (NodeData)item;
                                }
                                LOG.warn((Object)("Node not found, but property " + id + ", " + item.getQPath().getAsString() + " found. "));
                                continue;
                            }
                            LOG.warn((Object)("Unable to index node with id " + id + ", node does not exist."));
                        }
                        catch (RepositoryException e) {
                            LOG.error((Object)("Can't read next node data " + id), (Throwable)e);
                        }
                    } while (this.iter.hasNext());
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            Iterator<String> removedIds = new Iterator<String>(){
                private final Iterator<String> iter;
                {
                    this.iter = removedNodes.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public String next() {
                    return this.nextNodeId();
                }

                public String nextNodeId() throws NoSuchElementException {
                    return this.iter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            if (removedNodes.size() > 0 || addedNodes.size() > 0) {
                return this.handler.getChanges(removedIds, addedStates);
            }
        }
        return null;
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        WorkspaceContainerFacade container;
        try {
            container = this.rService.getRepository(this.repositoryName).getWorkspaceContainer(this.workspaceName);
        }
        catch (RepositoryException e) {
            throw new RepositoryConfigurationException(e);
        }
        String changesFilterClassName = this.config.getParameterValue("changesfilter-class", null);
        boolean recoveryFilterUsed = false;
        if (changesFilterClassName != null) {
            try {
                Class changesFilterClass = ClassLoading.forName((String)changesFilterClassName, (Object)this);
                if (changesFilterClass != null) {
                    recoveryFilterUsed = LocalIndexMarker.class.isAssignableFrom(changesFilterClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException(e.getMessage(), e);
            }
        }
        return new QueryHandlerContext(container, this.itemMgr, this.indexingTree, this.nodeTypeDataManager, this.nsReg, parentHandler, PrivilegedFileHelper.getAbsolutePath((File)this.getIndexDirectory()), this.extractor, true, recoveryFilterUsed, this.enableRemoteCalls, this.virtualTableResolver, this.indexRecovery, this.rpcService, this.repositoryName, this.wsId, this.cleanerHolder);
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            String queryImplClassName = this.handler.getQueryClass();
            Object obj = ClassLoading.forName((String)queryImplClassName, (Object)this).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(queryImplClassName + " is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString(), t);
        }
    }

    protected String getIndexDirParam() throws RepositoryConfigurationException {
        String dir = this.config.getParameterValue("index-dir", null);
        if (dir == null) {
            LOG.warn((Object)"index-dir parameter not found. Using outdated parameter name indexDir");
            dir = this.config.getParameterValue("indexDir");
        }
        return dir;
    }

    protected IndexingTree getIndexingTree() {
        return this.indexingTree;
    }

    public ExoContainerContext getExoContainerContext() {
        return this.ctx;
    }

    protected IndexerChangesFilter initializeChangesFilter() throws RepositoryException, RepositoryConfigurationException {
        IndexerChangesFilter newChangesFilter = null;
        Class changesFilterClass = DefaultChangesFilter.class;
        String changesFilterClassName = this.config.getParameterValue("changesfilter-class", null);
        try {
            if (changesFilterClassName != null) {
                changesFilterClass = ClassLoading.forName((String)changesFilterClassName, (Object)this);
            }
            Constructor constuctor = changesFilterClass.getConstructor(SearchManager.class, SearchManager.class, QueryHandlerEntry.class, IndexingTree.class, IndexingTree.class, QueryHandler.class, QueryHandler.class, ConfigurationManager.class);
            if (this.parentSearchManager != null) {
                newChangesFilter = (IndexerChangesFilter)constuctor.newInstance(this, this.parentSearchManager, this.config, this.indexingTree, this.parentSearchManager.getIndexingTree(), this.handler, this.parentSearchManager.getHandler(), this.cfm);
            }
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException("Unable to initialize change filter " + changesFilterClassName, (Throwable)e);
        }
        return newChangesFilter;
    }

    protected void initializeQueryHandler() throws RepositoryException, RepositoryConfigurationException {
        String className = this.config.getType();
        if (className == null) {
            throw new RepositoryConfigurationException("Content hanler       configuration fail");
        }
        try {
            Class qHandlerClass = ClassLoading.forName((String)className, (Object)this);
            try {
                Constructor constuctor = qHandlerClass.getConstructor(String.class, QueryHandlerEntry.class, ConfigurationManager.class);
                this.handler = (QueryHandler)constuctor.newInstance(this.wsContainerId, this.config, this.cfm);
            }
            catch (NoSuchMethodException e) {
                Constructor constuctor = qHandlerClass.getConstructor(QueryHandlerEntry.class, ConfigurationManager.class);
                this.handler = (QueryHandler)constuctor.newInstance(this.config, this.cfm);
            }
            QueryHandler parentHandler = this.parentSearchManager != null ? this.parentSearchManager.getHandler() : null;
            QueryHandlerContext context = this.createQueryHandlerContext(parentHandler);
            this.handler.setContext(context);
            if (this.parentSearchManager != null) {
                this.changesFilter = this.initializeChangesFilter();
                this.parentSearchManager.setChangesFilter(this.changesFilter);
            }
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setChangesFilter(IndexerChangesFilter changesFilter) {
        if (this.changesFilter == null) {
            this.changesFilter = changesFilter;
        }
    }

    private Set<String> getNodes(Query query) throws RepositoryException {
        HashSet<String> result = new HashSet<String>();
        QueryHits hits = null;
        try {
            ScoreNode sn;
            hits = this.handler.executeQuery(query);
            while ((sn = hits.nextScoreNode()) != null) {
                result.add(sn.getNodeId());
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        catch (IndexOfflineIOException e) {
            throw new IndexOfflineRepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (hits != null) {
                try {
                    hits.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Can not close QueryHits.", (Throwable)e);
                }
            }
        }
    }

    private boolean isPrefixMatch(InternalQName value, String prefix) throws RepositoryException {
        return value.getNamespace().equals(this.nsReg.getNamespaceURIByPrefix(prefix));
    }

    private boolean isPrefixMatch(QPath value, String prefix) throws RepositoryException {
        for (int i = 0; i < value.getEntries().length; ++i) {
            if (!this.isPrefixMatch(value.getEntries()[i], prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrefixMatch(ValueFactoryImpl valueFactory, String uuid, String prefix) throws RepositoryException {
        ItemData node = this.itemMgr.getItemData(uuid);
        if (node != null && node.isNode()) {
            List<PropertyData> props = this.itemMgr.getChildPropertiesData((NodeData)node);
            for (PropertyData propertyData : props) {
                if (propertyData.getType() != 8 && propertyData.getType() != 7) continue;
                for (ValueData vdata : propertyData.getValues()) {
                    Value val = valueFactory.loadValue(vdata, propertyData.getType());
                    if (!(propertyData.getType() == 8 ? this.isPrefixMatch(((PathValue)val).getQPath(), prefix) : propertyData.getType() == 7 && this.isPrefixMatch(((NameValue)val).getQName(), prefix))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isTXAware() {
        return false;
    }

    public String getWsId() {
        return this.wsId;
    }

    @Override
    public void suspend() throws SuspendException {
        if (this.suspend != null) {
            this.isResponsibleForResuming.set(true);
            try {
                this.rpcService.executeCommandOnAllNodes(this.suspend, true, new Serializable[0]);
            }
            catch (SecurityException e) {
                throw new SuspendException(e);
            }
            catch (RPCException e) {
                throw new SuspendException(e);
            }
        } else {
            this.suspendLocally();
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    public void setOnline(boolean isOnline, boolean allowQuery, boolean dropStaleIndexes) throws IOException {
        this.handler.setOnline(isOnline, allowQuery, dropStaleIndexes);
    }

    public boolean isOnline() {
        return this.handler.isOnline();
    }

    @Override
    public void resume() throws ResumeException {
        if (this.resume != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.resume, true, new Serializable[0]);
            }
            catch (SecurityException e) {
                throw new ResumeException(e);
            }
            catch (RPCException e) {
                throw new ResumeException(e);
            }
            this.isResponsibleForResuming.set(false);
        } else {
            this.resumeLocally();
        }
    }

    @Managed
    @ManagedDescription(value="Index optimization ")
    public void optimize() {
        block10: {
            if (this.handler instanceof SearchIndex) {
                try {
                    if (this.isSuspended.get()) {
                        this.resume();
                        try {
                            ((SearchIndex)this.handler).getIndex().optimize();
                            break block10;
                        }
                        finally {
                            this.suspend();
                        }
                    }
                    ((SearchIndex)this.handler).getIndex().optimize();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (ResumeException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (SuspendException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                LOG.error((Object)"This kind of QuerHandler class doesn't support index optimization.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Managed
    @ManagedDescription(value="Checks if index has deletions.")
    public boolean hasDeletions() {
        if (this.handler instanceof SearchIndex) {
            boolean bl;
            if (!this.isSuspended.get()) return ((SearchIndex)this.handler).getIndex().hasDeletions();
            this.resume();
            try {
                bl = ((SearchIndex)this.handler).getIndex().hasDeletions();
            }
            catch (Throwable throwable) {
                try {
                    this.suspend();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
                catch (ResumeException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
                catch (SuspendException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            this.suspend();
            return bl;
        } else {
            LOG.error((Object)"This kind of QuerHandler class doesn't support 'hasDeletions' checking.");
        }
        return false;
    }

    @Managed
    @ManagedDescription(value="Starts hot async reindexing")
    public void reindex(@ManagedName(value="dropExisting") boolean dropExisting, @ManagedName(value="nThreads") int nThreads) throws IllegalStateException, ExecutionException, InterruptedException {
        this.reindexWorkspace(dropExisting, nThreads);
    }

    public CompletableFuture<Boolean> reindexWorkspace(boolean dropExisting, int nThreads) throws IllegalStateException {
        if (this.handler == null || this.handler.getIndexerIoModeHandler() == null || this.changesFilter == null) {
            throw new IllegalStateException("Index might have not been initialized yet.");
        }
        if (this.handler.getIndexerIoModeHandler().getMode() != IndexerIoMode.READ_WRITE) {
            throw new IllegalStateException("Index is not in READ_WRITE mode and reindexing can't be launched. Please start reindexing on coordinator node.");
        }
        if (this.isSuspended.get() || !this.handler.isOnline()) {
            throw new IllegalStateException("Can't start reindexing while index is " + (this.isSuspended.get() ? "SUSPENDED." : "already OFFLINE (it means that reindexing is in progress).") + ".");
        }
        LOG.info((Object)("Starting hot reindexing on the " + this.handler.getContext().getRepositoryName() + "/" + this.handler.getContext().getContainer().getWorkspaceName() + ", with" + (dropExisting ? "" : "out") + " dropping the existing indexes."));
        ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "HotReindexing-" + this.handler.getContext().getRepositoryName() + "-" + this.handler.getContext().getContainer().getWorkspaceName()));
        CompletableFuture<Boolean> reindexFuture = CompletableFuture.supplyAsync(() -> this.doReindexing(dropExisting, nThreads), executorService);
        reindexFuture.thenRun(() -> executorService.shutdown());
        return reindexFuture;
    }

    /*
     * Exception decompiling
     */
    protected boolean doReindexing(boolean dropExisting, int nThreads) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Managed
    @ManagedDescription(value="Hot async reindexing state")
    public String getHotReindexingState() {
        return this.hotReindexingState;
    }

    @Managed
    @ManagedDescription(value="Index IO mode (READ_ONLY/READ_WRITE)")
    public String getIOMode() {
        if (this.handler == null || this.handler.getIndexerIoModeHandler() == null) {
            return "not initialized";
        }
        return this.handler.getIndexerIoModeHandler().getMode() == IndexerIoMode.READ_WRITE ? "READ_WRITE" : "READ_ONLY";
    }

    @Managed
    @ManagedDescription(value="Index state (Online/Offline(indexing))")
    public String getState() {
        if (this.handler == null) {
            return "not initialized";
        }
        return this.handler.isOnline() ? "Online" : "Offline (indexing)";
    }

    @Managed
    @ManagedDescription(value="QueryHandler class")
    public String getQuerHandlerClass() {
        if (this.handler != null) {
            return this.handler.getClass().getCanonicalName();
        }
        return "not initialized";
    }

    @Managed
    @ManagedDescription(value="ChangesFilter class")
    public String getChangesFilterClass() {
        if (this.changesFilter != null) {
            return this.changesFilter.getClass().getCanonicalName();
        }
        return "not initialized";
    }

    private void initRemoteCommands() {
        if (!this.enableRemoteCalls) {
            return;
        }
        this.suspend = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-suspend-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                SearchManager.this.suspendLocally();
                return null;
            }
        });
        this.resume = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-resume-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                SearchManager.this.resumeLocally();
                return null;
            }
        });
        this.requestForResponsibleForResuming = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-requestForResponsibilityForResuming-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                return Boolean.valueOf(SearchManager.this.isResponsibleForResuming.get());
            }
        });
        this.changeIndexState = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.SearchManager-changeIndexerState-" + SearchManager.this.wsId + "-" + (SearchManager.this.parentSearchManager == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                boolean isOnline = (Boolean)args[0];
                boolean allowQuery = args.length == 2 ? (Boolean)args[1] : false;
                SearchManager.this.setOnline(isOnline, allowQuery, true);
                return null;
            }
        });
    }

    private void unregisterRemoteCommands() {
        if (this.suspend != null) {
            this.rpcService.unregisterCommand(this.suspend);
        }
        if (this.resume != null) {
            this.rpcService.unregisterCommand(this.resume);
        }
        if (this.requestForResponsibleForResuming != null) {
            this.rpcService.unregisterCommand(this.requestForResponsibleForResuming);
        }
        if (this.changeIndexState != null) {
            this.rpcService.unregisterCommand(this.changeIndexState);
        }
    }

    protected void suspendLocally() throws SuspendException {
        if (this.handler != null && !this.handler.isOnline()) {
            throw new SuspendException("Can't suspend index, while reindexing in progeress.");
        }
        if (!this.isSuspended.get()) {
            if (this.handler instanceof Suspendable) {
                ((Suspendable)((Object)this.handler)).suspend();
            }
            this.isSuspended.set(true);
        }
    }

    protected void resumeLocally() throws ResumeException {
        if (this.isSuspended.get()) {
            if (this.handler instanceof Suspendable) {
                ((Suspendable)((Object)this.handler)).resume();
            }
            this.isSuspended.set(false);
        }
    }

    @Override
    public void clean() throws BackupException {
        LOG.info((Object)("Start to clean lucene indexes of the workspace '" + this.workspaceName + "'"));
        try {
            final File indexDir = this.getIndexDirectory();
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    DirectoryHelper.removeDirectory(indexDir);
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void backup(final File storageDir) throws BackupException {
        LOG.info((Object)("Start to backup lucene indexes of the workspace '" + this.workspaceName + "'"));
        try {
            final File indexDir = this.getIndexDirectory();
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    if (!indexDir.exists()) {
                        throw new IOException("Can't backup index. Directory " + indexDir.getCanonicalPath() + " doesn't exists");
                    }
                    File destZip = new File(storageDir, SearchManager.this.getStorageName() + ".zip");
                    DirectoryHelper.compressDirectory(indexDir, destZip);
                    return null;
                }
            });
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    protected File getIndexDirectory() throws RepositoryConfigurationException {
        return new File(this.getIndexDirParam());
    }

    protected String getStorageName() {
        return "index";
    }

    public boolean isEnableRemoteCalls() {
        return this.enableRemoteCalls;
    }

    @Override
    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        try {
            File zipFile = new File((File)context.getObject("storage-dir"), this.getStorageName() + ".zip");
            if (PrivilegedFileHelper.exists((File)zipFile)) {
                return new DirectoryRestore(this.getIndexDirectory(), zipFile);
            }
            zipFile = new File((File)context.getObject("storage-dir"), this.getStorageName());
            if (PrivilegedFileHelper.exists((File)zipFile)) {
                return new DirectoryRestore(this.getIndexDirectory(), zipFile);
            }
            throw new BackupException("There is no backup data for index");
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private void cleanIndexDirectory(String path) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction(() -> {
            File newIndexFolder = new File(path);
            if (newIndexFolder.exists()) {
                DirectoryHelper.removeDirectory(newIndexFolder);
            }
            return null;
        });
    }

    private static /* synthetic */ Void lambda$doReindexing$3(File newIndexDir, File indexDir) throws Exception {
        DirectoryHelper.renameFile(newIndexDir, indexDir);
        return null;
    }

    static {
        String max = PropertyManager.getProperty((String)LUCENE_BOOLEAN_QUERY_MAX_CLAUSE_COUNT);
        int value = Integer.MAX_VALUE;
        if (max != null) {
            try {
                value = Integer.valueOf(max);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"The value of the property 'org.apache.lucene.maxClauseCount' must be an integer, the default value will be used.");
            }
        }
        BooleanQuery.setMaxClauseCount((int)value);
    }
}

