/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.RSyncConfiguration;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.jcr.impl.core.query.ispn.ISPNIndexInfos;
import org.exoplatform.services.jcr.impl.core.query.ispn.ISPNIndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.ispn.IndexerCacheStore;
import org.exoplatform.services.jcr.impl.core.query.ispn.RsyncIndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.persistence.manager.PersistenceManager;

public class ISPNIndexChangesFilter
extends IndexerChangesFilter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNIndexChangesFilter");
    public static final String PARAM_INFINISPAN_CACHESTORE_CLASS = "infinispan-cachestore-classname";
    private final Cache<Serializable, Object> cache;
    private final String wsId;

    public ISPNIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        this.wsId = searchManager.getWsId();
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        config.putParameterValue(PARAM_INFINISPAN_CACHESTORE_CLASS, IndexerCacheStore.class.getName());
        this.cache = factory.createCache("Indexer_" + searchManager.getWsId(), config);
        PrivilegedISPNCacheHelper.start(this.cache);
        PersistenceManager persistenceManager = (PersistenceManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceManager.class);
        Set stores = persistenceManager.getStores(IndexerCacheStore.class);
        IndexerCacheStore cacheStore = null;
        if (!stores.isEmpty()) {
            cacheStore = (IndexerCacheStore)stores.iterator().next();
        }
        cacheStore.register(searchManager, parentSearchManager, handler, parentHandler);
        IndexerIoModeHandler modeHandler = cacheStore.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.setIndexInfos(this.createIndexInfos(true, modeHandler, config, parentHandler));
            parentHandler.setIndexUpdateMonitor(new ISPNIndexUpdateMonitor(searchManager.getWsId(), this.cache, true, modeHandler));
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.setIndexInfos(this.createIndexInfos(false, modeHandler, config, handler));
            handler.setIndexUpdateMonitor(new ISPNIndexUpdateMonitor(searchManager.getWsId(), this.cache, false, modeHandler));
            handler.init();
        }
    }

    private IndexInfos createIndexInfos(Boolean system, IndexerIoModeHandler modeHandler, QueryHandlerEntry config, QueryHandler handler) throws RepositoryConfigurationException {
        try {
            RSyncConfiguration rSyncConfiguration = new RSyncConfiguration(config);
            if (rSyncConfiguration.getRsyncEntryName() != null) {
                return new RsyncIndexInfos(this.wsId, this.cache, system, modeHandler, handler.getContext().getIndexDirectory(), rSyncConfiguration);
            }
            return new ISPNIndexInfos(this.wsId, this.cache, true, modeHandler);
        }
        catch (RepositoryConfigurationException e) {
            return new ISPNIndexInfos(this.wsId, this.cache, true, modeHandler);
        }
    }

    @Override
    protected Log getLogger() {
        return LOG;
    }

    @Override
    protected void doUpdateIndex(ChangesFilterListsWrapper changes) {
        ChangesKey changesKey = new ChangesKey(this.wsId, IdGenerator.generate());
        try {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)changesKey, (Object)changes);
        }
        catch (Throwable throwable) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).remove((Object)changesKey);
            throw throwable;
        }
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).remove((Object)changesKey);
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    public void close() {
        PrivilegedISPNCacheHelper.stop(this.cache);
        ISPNCacheFactory.releaseUniqueInstance(this.cache.getCacheManager());
    }
}

