/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.EmptyTermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingleTermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.TermDocsCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class CachingIndexReader
extends FilterIndexReader {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.CachingIndexReader");
    private static long currentTick;
    private final BitSet shareableNodes;
    private final int[] inSegmentParents;
    private final Map<Integer, DocId> foreignParentDocIds = new ConcurrentHashMap<Integer, DocId>();
    private CacheInitializer cacheInitializer;
    private final long creationTick = CachingIndexReader.getNextCreationTick();
    private final DocNumberCache cache;
    private final Map<Integer, String> docNumber2uuid;
    private final TermDocsCache termDocsCache;

    CachingIndexReader(IndexReader delegatee, DocNumberCache cache, boolean initCache) throws IOException {
        super(delegatee);
        this.cache = cache;
        this.inSegmentParents = new int[delegatee.maxDoc()];
        Arrays.fill(this.inSegmentParents, -1);
        this.shareableNodes = this.initShareableNodes(delegatee);
        this.cacheInitializer = new CacheInitializer(delegatee);
        if (initCache) {
            this.cacheInitializer.run();
        }
        this.docNumber2uuid = Collections.synchronizedMap(new LRUMap(Math.max(10, delegatee.maxDoc() / 100)));
        this.termDocsCache = new TermDocsCache(delegatee, FieldNames.PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitSet initShareableNodes(IndexReader delegatee) throws IOException {
        BitSet shareableNodes = new BitSet();
        try (TermDocs tDocs = delegatee.termDocs(new Term(FieldNames.SHAREABLE_NODE, ""));){
            while (tDocs.next()) {
                shareableNodes.set(tDocs.doc());
            }
        }
        return shareableNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocId getParent(int n, BitSet deleted) throws IOException {
        boolean existing = false;
        int parentDocNum = this.inSegmentParents[n];
        DocId parent = parentDocNum != -1 ? DocId.create(parentDocNum) : this.foreignParentDocIds.get(n);
        if (parent != null) {
            existing = true;
            if (!parent.isValid(deleted)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(parent + " not valid anymore."));
                }
                parent = null;
            }
        }
        if (parent == null) {
            int plainDocId = -1;
            Document doc = this.document(n, FieldSelectors.UUID_AND_PARENT);
            String[] parentUUIDs = doc.getValues(FieldNames.PARENT);
            if (parentUUIDs.length == 0 || parentUUIDs[0].length() == 0) {
                parent = DocId.NULL;
            } else if (this.shareableNodes.get(n)) {
                parent = DocId.create(parentUUIDs);
            } else {
                if (!existing) {
                    Term id = new Term(FieldNames.UUID, parentUUIDs[0]);
                    try (TermDocs docs = this.termDocs(id);){
                        while (docs.next()) {
                            if (deleted.get(docs.doc())) continue;
                            plainDocId = docs.doc();
                            parent = DocId.create(plainDocId);
                            break;
                        }
                    }
                }
                if (parent == null) {
                    parent = DocId.create(parentUUIDs[0]);
                }
            }
            if (plainDocId != -1) {
                this.inSegmentParents[n] = plainDocId;
            } else {
                this.foreignParentDocIds.put(n, parent);
                if (existing) {
                    this.inSegmentParents[n] = -1;
                }
            }
        }
        return parent;
    }

    public long getCreationTick() {
        return this.creationTick;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        if (fieldSelector == FieldSelectors.UUID) {
            Document doc;
            Integer docNum = new Integer(n);
            String uuid = this.docNumber2uuid.get(docNum);
            if (uuid == null) {
                doc = super.document(n, fieldSelector);
                uuid = doc.get(FieldNames.UUID);
                this.docNumber2uuid.put(docNum, uuid);
            } else {
                doc = new Document();
                doc.add((Fieldable)new Field(FieldNames.UUID, uuid.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            return doc;
        }
        return super.document(n, fieldSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term != null && term.field() == FieldNames.UUID && this.cache != null) {
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && e.creationTick == this.creationTick && !this.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc);
            }
            try (TermDocs docs = this.in.termDocs(term);){
                if (docs.next()) {
                    this.cache.put(term.text(), this, docs.doc());
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc());
                    return singleTermDocs;
                }
                TermDocs termDocs = EmptyTermDocs.INSTANCE;
                return termDocs;
            }
        }
        return this.termDocsCache.termDocs(term);
    }

    protected void doClose() throws IOException {
        try {
            this.cacheInitializer.waitUntilStopped();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCreationTick() {
        Class<CachingIndexReader> clazz = CachingIndexReader.class;
        synchronized (CachingIndexReader.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentTick++;
        }
    }

    private final class CacheInitializer
    implements Runnable {
        private final IndexReader reader;
        private boolean running = false;
        private volatile boolean stopRequested = false;
        private static final String FILE_CACHE_NAME_ARRAY = "cache.inSegmentParents";

        public CacheInitializer(IndexReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheInitializer cacheInitializer = this;
            synchronized (cacheInitializer) {
                this.running = true;
            }
            try {
                if (this.stopRequested) {
                    return;
                }
                boolean initCacheFromFile = this.loadCacheFromFile();
                if (!initCacheFromFile) {
                    log.debug((Object)"persisted cache is not available, will load directly from the repository.");
                    this.initializeParents(this.reader);
                }
            }
            catch (IOException e) {
                if (!this.stopRequested) {
                    log.warn((Object)"Error initializing parents cache.", (Throwable)e);
                }
            }
            finally {
                CacheInitializer cacheInitializer2 = this;
                synchronized (cacheInitializer2) {
                    this.running = false;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilStopped() throws InterruptedException {
            this.stopRequested = true;
            CacheInitializer cacheInitializer = this;
            synchronized (cacheInitializer) {
                while (this.running) {
                    this.wait();
                }
            }
        }

        private void initializeParents(IndexReader reader) throws IOException {
            long time = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            final HashMap docs = new HashMap();
            this.collectTermDocs(reader, new Term(FieldNames.UUID, ""), new TermDocsCollector(){

                @Override
                public void collect(Term term, TermDocs tDocs) throws IOException {
                    String uuid = term.text();
                    while (tDocs.next()) {
                        int doc = tDocs.doc();
                        if (CachingIndexReader.this.shareableNodes.get(doc)) continue;
                        NodeInfo info = new NodeInfo(doc, uuid);
                        docs.put(new Integer(doc), info);
                    }
                }
            });
            this.collectTermDocs(reader, new Term(FieldNames.PARENT, "0"), new TermDocsCollector(){

                @Override
                public void collect(Term term, TermDocs tDocs) throws IOException {
                    String uuid = term.text();
                    while (tDocs.next()) {
                        Integer docId = new Integer(tDocs.doc());
                        NodeInfo info = (NodeInfo)docs.get(docId);
                        if (info == null) continue;
                        info.parent = uuid;
                        docs.remove(docId);
                        docs.put(info.uuid, info);
                    }
                }
            });
            if (this.stopRequested) {
                return;
            }
            double foreignParents = 0.0;
            for (NodeInfo info : docs.values()) {
                NodeInfo parent = (NodeInfo)docs.get(info.parent);
                if (parent != null) {
                    CachingIndexReader.this.inSegmentParents[info.docId] = parent.docId;
                    continue;
                }
                if (info.parent != null) {
                    foreignParents += 1.0;
                    CachingIndexReader.this.foreignParentDocIds.put(info.docId, DocId.create(info.parent));
                    continue;
                }
                if (CachingIndexReader.this.shareableNodes.get(info.docId)) {
                    Document doc = reader.document(info.docId, FieldSelectors.UUID_AND_PARENT);
                    CachingIndexReader.this.foreignParentDocIds.put(info.docId, DocId.create(doc.getValues(FieldNames.PARENT)));
                    continue;
                }
                CachingIndexReader.this.foreignParentDocIds.put(info.docId, DocId.NULL);
            }
            this.saveCacheToFile();
            if (log.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getPercentInstance();
                nf.setMaximumFractionDigits(1);
                time = System.currentTimeMillis() - time;
                if (CachingIndexReader.this.inSegmentParents.length > 0) {
                    foreignParents /= (double)CachingIndexReader.this.inSegmentParents.length;
                }
                log.debug("initialized {} DocIds in {} ms, {} foreign parents", new Object[]{new Integer(CachingIndexReader.this.inSegmentParents.length), new Long(time), nf.format(foreignParents)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectTermDocs(IndexReader reader, Term start, TermDocsCollector collector) throws IOException {
            try (TermDocs tDocs = reader.termDocs();
                 TermEnum terms = reader.terms(start);){
                Term t;
                int count = 0;
                while ((t = terms.term()) != null && t.field() == start.field()) {
                    tDocs.seek(terms);
                    collector.collect(t, tDocs);
                    if (++count % 10000 == 0 && this.stopRequested) {
                    } else if (terms.next()) continue;
                    break;
                }
            }
        }

        public void saveCacheToFile() throws IOException {
            try (IndexOutput io = this.reader.directory().createOutput(FILE_CACHE_NAME_ARRAY);){
                for (int parent : CachingIndexReader.this.inSegmentParents) {
                    io.writeInt(parent);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error saving cache.inSegmentParents: " + e.getMessage()), (Throwable)e);
            }
        }

        private boolean loadCacheFromFile() throws IOException {
            block13: {
                boolean bl;
                block12: {
                    IndexInput ii = this.reader.directory().openInput(FILE_CACHE_NAME_ARRAY);
                    try {
                        long time = System.currentTimeMillis();
                        for (int i = 0; i < CachingIndexReader.this.inSegmentParents.length; ++i) {
                            CachingIndexReader.this.inSegmentParents[i] = ii.readInt();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("persisted cache initialized {} DocIds in {} ms", new Object[]{CachingIndexReader.this.inSegmentParents.length, System.currentTimeMillis() - time});
                        }
                        bl = true;
                        if (ii == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ii != null) {
                                try {
                                    ii.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (FileNotFoundException ignore) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Saved state (file-based) of CachingIndexReader has not been initialized yet", (Throwable)ignore);
                            }
                            break block13;
                        }
                        catch (IOException ignore) {
                            log.warn((Object)"Saved state of CachingIndexReader is corrupt, will try to remove offending file cache.inSegmentParents", (Throwable)ignore);
                            this.reader.directory().deleteFile(FILE_CACHE_NAME_ARRAY);
                        }
                    }
                    ii.close();
                }
                return bl;
            }
            return false;
        }
    }

    private static final class NodeInfo {
        final int docId;
        final String uuid;
        String parent;

        public NodeInfo(int docId, String uuid) {
            this.docId = docId;
            this.uuid = uuid;
        }
    }

    private static interface TermDocsCollector {
        public void collect(Term var1, TermDocs var2) throws IOException;
    }
}

