/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;

public class ChangesHolder
implements Externalizable {
    private static final int STORED_FLAG = 1;
    private static final int INDEXED_FLAG = 4;
    private static final int TOKENIZED_FLAG = 8;
    private static final int OMIT_NORMS_FLAG = 16;
    private static final int BINARY_FLAG = 32;
    private static final int STORE_TERM_VECTOR_FLAG = 64;
    private static final int STORE_POSITION_WITH_TERM_VECTOR_FLAG = 128;
    private static final int STORE_OFFSET_WITH_TERM_VECTOR_FLAG = 256;
    private static final int LAZY_FLAG = 512;
    private static final int OMIT_TF_FLAG = 1024;
    private static final int BOOST_FLAG = 2048;
    private List<String> remove;
    private Collection<Document> add;

    public ChangesHolder() {
    }

    public ChangesHolder(Collection<String> remove, Collection<Document> add) {
        this.remove = new ArrayList<String>(remove);
        this.add = add;
    }

    public Collection<String> getRemove() {
        return this.remove;
    }

    public Collection<Document> getAdd() {
        return this.add;
    }

    public Collection<String> getAddIds() {
        LinkedList<String> ids = new LinkedList<String>();
        for (Document doc : this.add) {
            ids.add(this.getDocId(doc));
        }
        return ids;
    }

    public String getDocId(Document doc) {
        return doc.get(FieldNames.UUID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.remove = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            this.remove.add(in.readUTF());
        }
        this.add = new LinkedList<Document>();
        while (in.readBoolean()) {
            Document doc = new Document();
            doc.setBoost(in.readFloat());
            int l = in.readInt();
            for (int i = 0; i < l; ++i) {
                doc.add((Fieldable)ChangesHolder.readField(in, doc));
            }
            this.add.add(doc);
        }
    }

    private static Field readField(ObjectInput in, Document doc) throws IOException, ClassNotFoundException {
        String name = in.readUTF();
        int flags = in.readInt();
        float boost = (flags & 0x800) > 0 ? in.readFloat() : 1.0f;
        Object value = in.readObject();
        Field field = value instanceof TokenStream ? new Field(name, (TokenStream)value, ChangesHolder.getTermVectorParameter(flags)) : new Field(name, (String)value, ChangesHolder.getStoreParameter(flags), ChangesHolder.getIndexParameter(flags), ChangesHolder.getTermVectorParameter(flags));
        field.setBoost(boost);
        field.setOmitNorms((flags & 0x10) > 0);
        FieldInfo.IndexOptions indexOptions = (flags & 0x400) > 0 ? FieldInfo.IndexOptions.DOCS_ONLY : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        field.setIndexOptions(indexOptions);
        return field;
    }

    private static Field.Index getIndexParameter(int flags) {
        if ((flags & 4) == 0) {
            return Field.Index.NO;
        }
        if ((flags & 8) > 0) {
            return Field.Index.ANALYZED;
        }
        return Field.Index.NOT_ANALYZED;
    }

    private static Field.Store getStoreParameter(int flags) {
        if ((flags & 1) > 0) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    private static Field.TermVector getTermVectorParameter(int flags) {
        if ((flags & 0x80) > 0 && (flags & 0x100) > 0) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        if ((flags & 0x80) > 0) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if ((flags & 0x100) > 0) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if ((flags & 0x40) > 0) {
            return Field.TermVector.YES;
        }
        return Field.TermVector.NO;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int length = this.remove.size();
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeUTF(this.remove.get(i));
        }
        out.flush();
        for (Document doc : this.add) {
            out.writeBoolean(true);
            out.writeFloat(doc.getBoost());
            List fields = doc.getFields();
            int l = fields.size();
            out.writeInt(l);
            for (int i = 0; i < l; ++i) {
                ChangesHolder.writeField(out, (Fieldable)fields.get(i));
            }
            out.flush();
        }
        out.writeBoolean(false);
    }

    private static void writeField(ObjectOutput out, Fieldable field) throws IOException {
        out.writeUTF(field.name());
        ChangesHolder.writeFlags(out, field);
        if (field.getBoost() != 1.0f) {
            out.writeFloat(field.getBoost());
        }
        ChangesHolder.writeValue(out, field);
    }

    private static void writeValue(ObjectOutput out, Fieldable field) throws IOException {
        Object o = field.stringValue();
        if (o != null) {
            out.writeObject(o);
            return;
        }
        o = field.tokenStreamValue();
        if (o != null) {
            out.writeObject(o);
            return;
        }
        o = field.readerValue();
        throw new RuntimeException("Unsupported value " + o);
    }

    private static void writeFlags(ObjectOutput out, Fieldable field) throws IOException {
        int flags = 0;
        if (field.isStored()) {
            flags |= 1;
        }
        if (field.isIndexed()) {
            flags |= 4;
        }
        if (field.isTokenized()) {
            flags |= 8;
        }
        if (field.getOmitNorms()) {
            flags |= 0x10;
        }
        if (field.isBinary()) {
            flags |= 0x20;
        }
        if (field.isTermVectorStored()) {
            flags |= 0x40;
        }
        if (field.isStorePositionWithTermVector()) {
            flags |= 0x80;
        }
        if (field.isStoreOffsetWithTermVector()) {
            flags |= 0x100;
        }
        if (field.isLazy()) {
            flags |= 0x200;
        }
        if (field instanceof AbstractField && ((AbstractField)field).getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
            flags |= 0x400;
        }
        if (field.getBoost() != 1.0f) {
            flags |= 0x800;
        }
        out.writeInt(flags);
    }
}

