/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IndexingConfigurationEntityResolver
implements EntityResolver {
    private static final Map<String, String> SYSTEM_IDS;

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in;
        String resourceName = SYSTEM_IDS.get(systemId);
        if (resourceName != null && (in = this.getClass().getResourceAsStream(resourceName)) != null) {
            return new InputSource(in);
        }
        return null;
    }

    static {
        HashMap<String, String> systemIds = new HashMap<String, String>();
        systemIds.put("http://www.exoplatform.org/dtd/indexing-configuration-1.0.dtd", "indexing-configuration-1.0.dtd");
        systemIds.put("http://www.exoplatform.org/dtd/indexing-configuration-1.1.dtd", "indexing-configuration-1.1.dtd");
        systemIds.put("http://www.exoplatform.org/dtd/indexing-configuration-1.2.dtd", "indexing-configuration-1.2.dtd");
        SYSTEM_IDS = Collections.unmodifiableMap(systemIds);
    }
}

