/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.value.EditableBinaryValue;
import org.exoplatform.services.jcr.impl.dataflow.ByteArrayNewValueData;

public class ByteArrayNewEditableValueData
extends ByteArrayNewValueData
implements EditableBinaryValue {
    public ByteArrayNewEditableValueData(int orderNumber, byte[] bytes) throws IOException {
        super(orderNumber, bytes);
    }

    @Override
    public void update(InputStream stream, long length, long position) throws IOException, RepositoryException {
        long read;
        this.validateAndAdjustLenght(length, position, Integer.MAX_VALUE);
        long newSize = Math.max(length + position, (long)this.value.length);
        byte[] newBytes = new byte[(int)newSize];
        if (position > 0L) {
            System.arraycopy(this.value, 0, newBytes, 0, (int)(position < (long)this.value.length ? position : (long)this.value.length));
        }
        boolean doRead = true;
        byte[] buff = new byte[2048];
        while (doRead && (read = (long)stream.read(buff)) >= 0L) {
            if (position + read > (long)newBytes.length) {
                read = (long)newBytes.length - position;
                doRead = false;
            }
            System.arraycopy(buff, 0, newBytes, (int)position, (int)read);
            position += read;
        }
        if (position < (long)this.value.length) {
            System.arraycopy(this.value, (int)position, newBytes, (int)position, (int)((long)this.value.length - position));
        }
        this.value = newBytes;
    }

    @Override
    public void setLength(long size) throws IOException, RepositoryException {
        if (size < 0L) {
            throw new IOException("Size must be higher or equals 0. But given " + size);
        }
        byte[] newBytes = new byte[(int)size];
        System.arraycopy(this.value, 0, newBytes, 0, Math.min(this.value.length, newBytes.length));
        this.value = newBytes;
    }
}

