/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class ItemDataRemoveVisitor
extends ItemDataTraversingVisitor {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemDataRemoveVisitor");
    protected List<ItemState> itemRemovedStates = new ArrayList<ItemState>();
    protected List<ItemState> reversedItemRemovedStates = null;
    protected boolean validate;
    protected NodeData removedRoot = null;
    protected QPath ancestorToSave = null;
    private final NodeTypeDataManager nodeTypeManager;
    private final AccessManager accessManager;
    private final ConversationState userState;

    public ItemDataRemoveVisitor(ItemDataConsumer dataManager, QPath ancestorToSave) {
        this(dataManager, ancestorToSave, null, null, null);
        this.validate = false;
    }

    public ItemDataRemoveVisitor(ItemDataConsumer dataManager, QPath ancestorToSave, NodeTypeDataManager nodeTypeManager, AccessManager accessManager, ConversationState userState) {
        super(dataManager);
        this.nodeTypeManager = nodeTypeManager;
        this.accessManager = accessManager;
        this.userState = userState;
        this.validate = true;
        this.ancestorToSave = ancestorToSave;
    }

    protected void validate(PropertyData property) throws RepositoryException {
        this.validateAccessDenied(property);
        this.validateConstraints(property);
        this.validateVersion(property);
        this.validateLock(property);
    }

    protected void validateAccessDenied(PropertyData property) throws RepositoryException {
        NodeData parent = (NodeData)this.dataManager.getItemData(property.getParentIdentifier());
        if (!this.accessManager.hasPermission(parent.getACL(), "read", this.userState.getIdentity())) {
            throw new AccessDeniedException("Access denied " + property.getQPath().getAsString() + " for " + this.userState.getIdentity().getUserId() + " (get item parent by id)");
        }
    }

    protected void validateConstraints(PropertyData property) throws RepositoryException {
    }

    protected void validateVersion(PropertyData property) throws RepositoryException {
    }

    protected void validateLock(PropertyData property) throws RepositoryException {
    }

    protected void validate(NodeData node) throws RepositoryException {
        this.validateAccessDenied(node);
        if (this.nodeTypeManager.isNodeType(Constants.MIX_REFERENCEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
            this.validateReferential(node);
        }
        this.validateConstraints(node);
        this.validateVersion(node);
        this.validateLock(node);
    }

    protected void validateAccessDenied(NodeData node) throws RepositoryException {
        if (!this.accessManager.hasPermission(node.getACL(), "read", this.userState.getIdentity())) {
            throw new AccessDeniedException("Access denied " + node.getQPath().getAsString() + " for " + this.userState.getIdentity().getUserId() + " (get item by id)");
        }
    }

    protected void validateReferential(NodeData node) throws RepositoryException {
        List<PropertyData> refs = this.dataManager.getReferencesData(node.getIdentifier(), true);
        for (PropertyData rpd : refs) {
            if (this.isRemoveDescendant(this.removedRoot)) {
                this.entering(rpd, this.currentLevel);
                continue;
            }
            NodeData refParent = (NodeData)this.dataManager.getItemData(rpd.getParentIdentifier());
            if (!this.accessManager.hasPermission(refParent.getACL(), "read", this.userState.getIdentity())) {
                throw new AccessDeniedException("Access denied " + rpd.getQPath().getAsString() + " for " + this.userState.getIdentity().getUserId() + " (get reference property parent by id)");
            }
            throw new ReferentialIntegrityException("This node " + node.getQPath().getAsString() + " is currently the target of a REFERENCE property " + rpd.getQPath().getAsString() + " located in this workspace. Session id: " + this.userState.getIdentity().getUserId());
        }
    }

    protected boolean isRemoveDescendant(ItemData item) throws RepositoryException {
        return item.getQPath().isDescendantOf(this.removedRoot.getQPath());
    }

    protected void validateConstraints(NodeData node) throws RepositoryException {
    }

    protected void validateVersion(NodeData node) throws RepositoryException {
    }

    protected void validateLock(NodeData node) throws RepositoryException {
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        ItemState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering property " + property.getQPath().getAsString()));
        }
        if (this.validate) {
            this.validate(property);
        }
        if (!this.itemRemovedStates.contains(state = new ItemState(property = (PropertyData)((Object)this.copyItemDataDelete(property)), 4, true, this.ancestorToSave != null ? this.ancestorToSave : this.removedRoot.getQPath()))) {
            this.itemRemovedStates.add(state);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("A property " + property.getQPath().getAsString() + " is already listed for remove"));
        }
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering node " + node.getQPath().getAsString()));
        }
        if (level == 0) {
            this.removedRoot = node;
        }
        if (this.validate) {
            this.validate(node);
        }
        if (!(node instanceof TransientItemData)) {
            node = (NodeData)((Object)this.copyItemDataDelete(node));
        }
        ItemState state = new ItemState(node, 4, true, this.ancestorToSave != null ? this.ancestorToSave : this.removedRoot.getQPath());
        this.itemRemovedStates.add(state);
    }

    @Override
    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(NodeData node, int level) throws RepositoryException {
    }

    public List<ItemState> getRemovedStates() {
        if (this.reversedItemRemovedStates == null) {
            Collections.reverse(this.itemRemovedStates);
            this.reversedItemRemovedStates = this.itemRemovedStates;
        }
        return this.reversedItemRemovedStates;
    }

    protected TransientItemData copyItemDataDelete(ItemData item) throws RepositoryException {
        if (item == null) {
            return null;
        }
        if (item.isNode()) {
            NodeData node = (NodeData)item;
            AccessControlList acl = node.getACL();
            if (acl == null) {
                throw new RepositoryException("Node ACL is null. " + node.getQPath().getAsString() + " " + node.getIdentifier());
            }
            return new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), acl);
        }
        PropertyData prop = (PropertyData)item;
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
        return newData;
    }
}

