/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.util.Calendar;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LongPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class LongValueData
extends AbstractValueData {
    protected long value;

    protected LongValueData(int orderNumber, long value) {
        super(orderNumber);
        this.value = value;
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof LongValueData) {
            return ((LongValueData)another).value == this.value;
        }
        return false;
    }

    @Override
    protected byte[] spoolInternalValue() {
        return Long.toString(this.value).getBytes();
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new LongPersistedValueData(orderNumber, this.value);
    }

    @Override
    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    @Override
    protected Long getLong() {
        return this.value;
    }

    @Override
    protected Double getDouble() {
        return this.value;
    }

    @Override
    protected String getString() {
        return Long.toString(this.value);
    }

    @Override
    protected Calendar getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.value);
        return calendar;
    }
}

