/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import java.util.ArrayList;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ItemStateReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;

public class PlainChangesLogReader {
    private SpoolConfig spoolConfig;
    private int maxBufferSize;
    private ReaderSpoolFileHolder holder;

    public PlainChangesLogReader(ReaderSpoolFileHolder holder, SpoolConfig spoolConfig) {
        this.spoolConfig = spoolConfig;
        this.holder = holder;
    }

    public PlainChangesLog read(ObjectReader in) throws UnknownClassIdException, IOException {
        int key = in.readInt();
        if (key != 4) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        int eventType = in.readInt();
        String sessionId = in.readString();
        ArrayList<ItemState> items = new ArrayList<ItemState>();
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            ItemStateReader isr = new ItemStateReader(this.holder, this.spoolConfig);
            ItemState is = isr.read(in);
            items.add(is);
        }
        return new PlainChangesLogImpl(items, sessionId, eventType);
    }
}

