/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ExtendedMandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.quota.ApplyPersistedChangesTask;
import org.exoplatform.services.jcr.impl.quota.BaseQuotaManager;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;
import org.exoplatform.services.jcr.impl.quota.ChangesLog;
import org.exoplatform.services.jcr.impl.quota.ExceededQuotaLimitException;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.UnknownQuotaLimitException;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;

public class ChangesListener
implements ExtendedMandatoryItemsPersistenceListener {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ChangesListener");
    protected ThreadLocal<ChangesItem> pendingChanges = new ThreadLocal();
    protected ChangesLog changesLog = new ChangesLog();
    protected final WorkspaceQuotaManager wqm;
    protected final RPCService rpcService;
    protected final String wsName;
    protected final String rName;
    protected final String uniqueName;
    protected final QuotaPersister quotaPersister;
    protected RemoteCommand applyPersistedChangesTask;
    protected final ExecutorService executor;
    protected final BaseQuotaManager.ExceededQuotaBehavior exceededQuotaBehavior;
    protected final LocationFactory lFactory;

    ChangesListener(WorkspaceQuotaManager wqm) {
        this.wqm = wqm;
        this.rpcService = wqm.getContext().rpcService;
        this.wsName = wqm.getContext().wsName;
        this.rName = wqm.getContext().rName;
        this.uniqueName = wqm.getContext().uniqueName;
        this.quotaPersister = wqm.getContext().quotaPersister;
        this.executor = wqm.getContext().executor;
        this.exceededQuotaBehavior = wqm.getContext().exceededQuotaBehavior;
        this.lFactory = wqm.getContext().lFactory;
        this.initApplyPersistedChangesTask();
        this.rpcService.registerCommand(this.applyPersistedChangesTask);
    }

    @Override
    public void onSaveItems(ItemStateChangesLog itemStates) {
        try {
            ChangesItem changesItem = new ChangesItem();
            for (ItemState state : itemStates.getAllStates()) {
                if (!state.getData().isNode()) {
                    String nodePath = this.getPath(state.getData().getQPath().makeParentPath());
                    Set<String> parentsWithQuota = this.quotaPersister.getAllParentNodesWithQuota(this.rName, this.wsName, nodePath);
                    for (String parent : parentsWithQuota) {
                        changesItem.updateNodeChangedSize(parent, state.getChangedSize());
                        this.addPathsWithAsyncUpdate(changesItem, parent);
                    }
                    changesItem.updateWorkspaceChangedSize(state.getChangedSize());
                    continue;
                }
                this.addPathsWithUnknownChangedSize(changesItem, state);
            }
            this.validatePendingChanges(changesItem);
            this.pendingChanges.set(changesItem);
        }
        catch (ExceededQuotaLimitException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void addPathsWithUnknownChangedSize(ChangesItem changesItem, ItemState state) {
        if (!state.isPersisted() && (state.isDeleted() || state.isRenamed())) {
            String itemPath = this.getPath(state.getData().getQPath());
            for (String trackedPath : this.quotaPersister.getAllTrackedNodes(this.rName, this.wsName)) {
                if (!itemPath.startsWith(trackedPath)) continue;
                changesItem.addPathWithUnknownChangedSize(itemPath);
            }
        }
    }

    private void addPathsWithAsyncUpdate(ChangesItem changesItem, String quotableParent) {
        boolean isAsyncUpdate;
        try {
            isAsyncUpdate = this.quotaPersister.isNodeQuotaOrGroupOfNodesQuotaAsync(this.rName, this.wsName, quotableParent);
        }
        catch (UnknownQuotaLimitException e) {
            isAsyncUpdate = true;
        }
        if (isAsyncUpdate) {
            changesItem.addPathWithAsyncUpdate(quotableParent);
        }
    }

    private void validatePendingChanges(ChangesItem changesItem) throws ExceededQuotaLimitException {
        long delta = changesItem.getWorkspaceChangedSize() + this.changesLog.getWorkspaceChangedSize();
        if (delta > 0L) {
            this.validatePendingWorkspaceChanges(delta);
            this.validatePendingRepositoryChanges(delta);
            this.validatePendingGlobalChanges(delta);
        }
        this.validatePendingNodesChanges(changesItem.getAllNodesCalculatedChangedSize());
    }

    private void validatePendingWorkspaceChanges(long delta) throws ExceededQuotaLimitException {
        try {
            long quotaLimit = this.quotaPersister.getWorkspaceQuota(this.rName, this.wsName);
            try {
                long dataSize = this.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
                if (dataSize + delta > quotaLimit) {
                    this.behaveWhenQuotaExceeded("In workspace '" + this.wqm.uniqueName + "' data size exceeded quota limit");
                }
            }
            catch (UnknownDataSizeException e) {
                return;
            }
        }
        catch (UnknownQuotaLimitException e) {
            return;
        }
    }

    private void validatePendingRepositoryChanges(long delta) throws ExceededQuotaLimitException {
        try {
            long quotaLimit = this.quotaPersister.getRepositoryQuota(this.rName);
            try {
                long dataSize = this.quotaPersister.getRepositoryDataSize(this.rName);
                if (dataSize + delta > quotaLimit) {
                    this.behaveWhenQuotaExceeded("In repository '" + this.rName + "' data size exceeded quota limit");
                }
            }
            catch (UnknownDataSizeException e) {
                return;
            }
        }
        catch (UnknownQuotaLimitException e) {
            return;
        }
    }

    private void validatePendingGlobalChanges(long delta) throws ExceededQuotaLimitException {
        try {
            long quotaLimit = this.quotaPersister.getGlobalQuota();
            try {
                long dataSize = this.quotaPersister.getGlobalDataSize();
                if (dataSize + delta > quotaLimit) {
                    this.behaveWhenQuotaExceeded("Global data size exceeded quota limit");
                }
            }
            catch (UnknownDataSizeException e) {
                return;
            }
        }
        catch (UnknownQuotaLimitException e) {
            return;
        }
    }

    private void validatePendingNodesChanges(Map<String, Long> calculatedNodesChangedSize) throws ExceededQuotaLimitException {
        for (Map.Entry<String, Long> entry : calculatedNodesChangedSize.entrySet()) {
            String nodePath = entry.getKey();
            long delta = entry.getValue() + this.changesLog.getNodeChangedSize(nodePath);
            if (delta <= 0L) continue;
            try {
                long dataSize = this.quotaPersister.getNodeDataSize(this.rName, this.wsName, nodePath);
                try {
                    long quotaLimit = this.quotaPersister.getNodeQuotaOrGroupOfNodesQuota(this.rName, this.wsName, nodePath);
                    if (dataSize + delta <= quotaLimit) continue;
                    this.behaveWhenQuotaExceeded("Node '" + nodePath + "' data size exceeded quota limit");
                }
                catch (UnknownQuotaLimitException e) {
                }
            }
            catch (UnknownDataSizeException e) {}
        }
    }

    private void behaveWhenQuotaExceeded(String message) throws ExceededQuotaLimitException {
        switch (this.exceededQuotaBehavior) {
            case EXCEPTION: {
                throw new ExceededQuotaLimitException(message);
            }
            case WARNING: {
                this.LOG.warn((Object)message);
            }
        }
    }

    @Override
    public void onCommit() {
        ChangesItem changesItem = this.pendingChanges.get();
        try {
            this.pushChangesToCoordinator(changesItem.extractSyncChanges());
            this.changesLog.add(changesItem);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Can't push changes to coordinator", e.getCause());
        }
        catch (RPCException e) {
            throw new IllegalStateException("Can't push changes to coordinator", e.getCause());
        }
        finally {
            this.pendingChanges.remove();
        }
    }

    protected void pushAllChangesToCoordinator() throws SecurityException, RPCException {
        ChangesItem changesItem = this.changesLog.pollAndMergeAll();
        this.pushChangesToCoordinator(changesItem);
    }

    protected void pushChangesToCoordinator(ChangesItem changesItem) throws SecurityException, RPCException {
        if (!changesItem.isEmpty()) {
            this.rpcService.executeCommandOnCoordinator(this.applyPersistedChangesTask, true, new Serializable[]{changesItem});
        }
    }

    @Override
    public void onRollback() {
        this.pendingChanges.remove();
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    private String getPath(QPath path) {
        try {
            return this.lFactory.createJCRPath(path).getAsString(false);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void destroy() {
        this.rpcService.unregisterCommand(this.applyPersistedChangesTask);
    }

    private void initApplyPersistedChangesTask() {
        this.applyPersistedChangesTask = new RemoteCommand(){

            public String getId() {
                return "ChangesListener-" + ChangesListener.this.uniqueName + "-applyPersistedChangesTask";
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                ChangesItem changesItem = (ChangesItem)args[0];
                ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(ChangesListener.this.wqm.getContext(), changesItem);
                ChangesListener.this.executor.execute(task);
                return null;
            }
        };
    }
}

