/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GenericConnectionFactory
implements WorkspaceStorageConnectionFactory,
Cloneable {
    protected static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.GenericConnectionFactory");
    protected DataSource dbDataSource;
    protected final JDBCDataContainerConfig containerConfig;

    public GenericConnectionFactory(DataSource dataSource, JDBCDataContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
        this.dbDataSource = dataSource;
    }

    public GenericConnectionFactory cloneWith(DataSource datasource) {
        try {
            GenericConnectionFactory factory = (GenericConnectionFactory)this.clone();
            factory.dbDataSource = datasource;
            return factory;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        return this.openConnection(false);
    }

    @Override
    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                return new MultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return new SingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Connection getJdbcConnection(boolean readOnly) throws RepositoryException {
        try {
            Connection conn = this.dbDataSource.getConnection();
            if (readOnly) {
                conn.setReadOnly(readOnly);
            }
            return conn;
        }
        catch (SQLException e) {
            String err = "Error of JDBC connection open. SQLException: " + e.getMessage() + ", SQLState: " + e.getSQLState() + ", VendorError: " + e.getErrorCode();
            throw new RepositoryException(err, (Throwable)e);
        }
    }

    @Override
    public Connection getJdbcConnection() throws RepositoryException {
        return this.getJdbcConnection(false);
    }

    public boolean isReindexingSupported() {
        return false;
    }

    public boolean isIDNeededForPaging() {
        return true;
    }

    public boolean isOffsetSupported() {
        return true;
    }
}

