/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MSSQLMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MSSQLSingleDbJDBCConnection;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class MSSQLConnectionFactory
extends GenericConnectionFactory {
    public MSSQLConnectionFactory(DataSource dataSource, JDBCDataContainerConfig containerConfig) {
        super(dataSource, containerConfig);
    }

    @Override
    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                return new MSSQLMultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return new MSSQLSingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

