/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;

public class SingleDbJDBCConnection
extends JDBCStorageConnection {
    public SingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    protected String getInternalId(String identifier) {
        return this.containerConfig.containerName + identifier;
    }

    @Override
    protected String getIdentifier(String internalId) {
        if (internalId == null) {
            return null;
        }
        return internalId.substring(this.containerConfig.containerName.length());
    }

    @Override
    protected void prepareQueries() throws SQLException {
        this.FIND_ITEM_BY_ID = "select * from JCR_SITEM where ID=?";
        this.FIND_ITEM_BY_NAME = "select * from JCR_SITEM where CONTAINER_NAME=? and PARENT_ID=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.PARENT_ID=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_REFERENCES = "select P.ID, P.PARENT_ID, P.VERSION, P.P_TYPE, P.P_MULTIVALUED, P.NAME from JCR_SREF R, JCR_SITEM P where R.NODE_ID=? and P.CONTAINER_NAME=? and P.ID=R.PROPERTY_ID and P.I_CLASS=2";
        this.FIND_VALUES_BY_PROPERTYID = "select PROPERTY_ID, ORDER_NUM, DATA, STORAGE_DESC from JCR_SVALUE where PROPERTY_ID=? order by ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=? order by N_ORDER_NUM";
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME=? and PARENT_ID=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_SITEM where I_CLASS=2 and CONTAINER_NAME=? and PARENT_ID=? order by ID";
        this.FIND_MAX_PROPERTY_VERSIONS = "select max(VERSION) FROM JCR_SITEM WHERE PARENT_ID=? and CONTAINER_NAME=? and NAME=? and I_INDEX=? and I_CLASS=2";
        this.INSERT_NODE = "insert into JCR_SITEM(ID, PARENT_ID, NAME, CONTAINER_NAME, VERSION, I_CLASS, I_INDEX, N_ORDER_NUM) VALUES(?,?,?,?,?,1,?,?)";
        this.INSERT_PROPERTY = "insert into JCR_SITEM(ID, PARENT_ID, NAME, CONTAINER_NAME, VERSION, I_CLASS, I_INDEX, P_TYPE, P_MULTIVALUED) VALUES(?,?,?,?,?,2,?,?,?)";
        this.INSERT_VALUE = "insert into JCR_SVALUE(DATA, ORDER_NUM, PROPERTY_ID, STORAGE_DESC) VALUES(?,?,?,?)";
        this.INSERT_REF = "insert into JCR_SREF(NODE_ID, PROPERTY_ID, ORDER_NUM) VALUES(?,?,?)";
        this.RENAME_NODE = "update JCR_SITEM set PARENT_ID=?, NAME=?, VERSION=?, I_INDEX=?, N_ORDER_NUM=? where ID=?";
        this.UPDATE_NODE = "update JCR_SITEM set VERSION=?, I_INDEX=?, N_ORDER_NUM=? where ID=?";
        this.UPDATE_PROPERTY = "update JCR_SITEM set VERSION=?, P_TYPE=? where ID=?";
        this.DELETE_ITEM = "delete from JCR_SITEM where ID=?";
        this.DELETE_VALUE = "delete from JCR_SVALUE where PROPERTY_ID=?";
        this.DELETE_REF = "delete from JCR_SREF where PROPERTY_ID=?";
        this.FIND_NODES_COUNT = "select count(*) from JCR_SITEM I where I.I_CLASS=1 and I.CONTAINER_NAME=?";
        this.FIND_WORKSPACE_DATA_SIZE = "select sum(length(DATA)) from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID";
        this.FIND_WORKSPACE_PROPERTIES_ON_VALUE_STORAGE = "select V.PROPERTY_ID, V.STORAGE_DESC, V.ORDER_NUM from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID and V.STORAGE_DESC is not null";
        this.FIND_NODE_DATA_SIZE = "select sum(length(DATA)) from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID";
        this.FIND_NODE_PROPERTIES_ON_VALUE_STORAGE = "select V.PROPERTY_ID, V.STORAGE_DESC, V.ORDER_NUM from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID and V.STORAGE_DESC is not null";
        this.FIND_VALUE_STORAGE_DESC_AND_SIZE = "select length(DATA), STORAGE_DESC from JCR_SVALUE where PROPERTY_ID=?";
    }

    @Override
    protected int addNodeRecord(NodeData data) throws SQLException {
        if (this.insertNode == null) {
            this.insertNode = this.dbConnection.prepareStatement(this.INSERT_NODE);
        } else {
            this.insertNode.clearParameters();
        }
        this.insertNode.setString(1, this.getInternalId(data.getIdentifier()));
        this.insertNode.setString(2, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : this.getInternalId(data.getParentIdentifier()));
        this.insertNode.setString(3, data.getQPath().getName().getAsString());
        this.insertNode.setString(4, this.containerConfig.containerName);
        this.insertNode.setInt(5, data.getPersistedVersion());
        this.insertNode.setInt(6, data.getQPath().getIndex());
        this.insertNode.setInt(7, data.getOrderNumber());
        return this.insertNode.executeUpdate();
    }

    @Override
    protected int addPropertyRecord(PropertyData data) throws SQLException {
        if (this.insertProperty == null) {
            this.insertProperty = this.dbConnection.prepareStatement(this.INSERT_PROPERTY);
        } else {
            this.insertProperty.clearParameters();
        }
        this.insertProperty.setString(1, this.getInternalId(data.getIdentifier()));
        this.insertProperty.setString(2, this.getInternalId(data.getParentIdentifier()));
        this.insertProperty.setString(3, data.getQPath().getName().getAsString());
        this.insertProperty.setString(4, this.containerConfig.containerName);
        this.insertProperty.setInt(5, data.getPersistedVersion());
        this.insertProperty.setInt(6, data.getQPath().getIndex());
        this.insertProperty.setInt(7, data.getType());
        this.insertProperty.setBoolean(8, data.isMultiValued());
        return this.insertProperty.executeUpdate();
    }

    @Override
    protected int addReference(PropertyData data) throws SQLException, IOException {
        if (this.insertReference == null) {
            this.insertReference = this.dbConnection.prepareStatement(this.INSERT_REF);
        } else {
            this.insertReference.clearParameters();
        }
        List<ValueData> values = data.getValues();
        int added = 0;
        for (int i = 0; i < values.size(); ++i) {
            String refNodeIdentifier;
            ValueData vdata = values.get(i);
            try {
                refNodeIdentifier = ValueDataUtil.getString(vdata);
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.insertReference.setString(1, this.getInternalId(refNodeIdentifier));
            this.insertReference.setString(2, this.getInternalId(data.getIdentifier()));
            this.insertReference.setInt(3, i);
            added += this.insertReference.executeUpdate();
        }
        return added;
    }

    @Override
    protected int deleteReference(String propertyCid) throws SQLException {
        if (this.deleteReference == null) {
            this.deleteReference = this.dbConnection.prepareStatement(this.DELETE_REF);
        } else {
            this.deleteReference.clearParameters();
        }
        this.deleteReference.setString(1, propertyCid);
        return this.deleteReference.executeUpdate();
    }

    @Override
    protected int deleteItemByIdentifier(String cid) throws SQLException {
        if (this.deleteItem == null) {
            this.deleteItem = this.dbConnection.prepareStatement(this.DELETE_ITEM);
        } else {
            this.deleteItem.clearParameters();
        }
        this.deleteItem.setString(1, cid);
        return this.deleteItem.executeUpdate();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, this.containerConfig.containerName);
        this.findNodesByParentId.setString(2, parentCid);
        return this.findNodesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        } else {
            this.findLastOrderNumberByParentId.clearParameters();
        }
        this.findLastOrderNumberByParentId.setString(1, this.containerConfig.containerName);
        this.findLastOrderNumberByParentId.setString(2, parentIdentifier);
        return this.findLastOrderNumberByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesCountByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, this.containerConfig.containerName);
        this.findNodesCountByParentId.setString(2, parentCid);
        return this.findNodesCountByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, this.containerConfig.containerName);
        this.findPropertiesByParentId.setString(2, parentCid);
        return this.findPropertiesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, this.containerConfig.containerName);
        this.findItemByName.setString(2, parentId);
        this.findItemByName.setString(3, name);
        this.findItemByName.setInt(4, index);
        return this.findItemByName.executeQuery();
    }

    @Override
    protected ResultSet findPropertyByName(String parentCid, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, this.containerConfig.containerName);
        this.findPropertyByName.setString(2, parentCid);
        this.findPropertyByName.setString(3, name);
        return this.findPropertyByName.executeQuery();
    }

    @Override
    protected ResultSet findItemByIdentifier(String cid) throws SQLException {
        if (this.findItemById == null) {
            this.findItemById = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_ID);
        } else {
            this.findItemById.clearParameters();
        }
        this.findItemById.setString(1, cid);
        return this.findItemById.executeQuery();
    }

    @Override
    protected ResultSet findReferences(String cid) throws SQLException {
        if (this.findReferences == null) {
            this.findReferences = this.dbConnection.prepareStatement(this.FIND_REFERENCES);
        } else {
            this.findReferences.clearParameters();
        }
        this.findReferences.setString(1, cid);
        this.findReferences.setString(2, this.containerConfig.containerName);
        return this.findReferences.executeQuery();
    }

    @Override
    protected int updateNodeByIdentifier(int version, int index, int orderNumb, String cid) throws SQLException {
        if (this.updateNode == null) {
            this.updateNode = this.dbConnection.prepareStatement(this.UPDATE_NODE);
        } else {
            this.updateNode.clearParameters();
        }
        this.updateNode.setInt(1, version);
        this.updateNode.setInt(2, index);
        this.updateNode.setInt(3, orderNumb);
        this.updateNode.setString(4, cid);
        return this.updateNode.executeUpdate();
    }

    @Override
    protected int updatePropertyByIdentifier(int version, int type, String cid) throws SQLException {
        if (this.updateProperty == null) {
            this.updateProperty = this.dbConnection.prepareStatement(this.UPDATE_PROPERTY);
        } else {
            this.updateProperty.clearParameters();
        }
        this.updateProperty.setInt(1, version);
        this.updateProperty.setInt(2, type);
        this.updateProperty.setString(3, cid);
        return this.updateProperty.executeUpdate();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        throw new UnsupportedOperationException("findChildNodesByParentIdentifier is not supported for old queries");
    }

    @Override
    protected int addValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException {
        if (this.insertValue == null) {
            this.insertValue = this.dbConnection.prepareStatement(this.INSERT_VALUE);
        } else {
            this.insertValue.clearParameters();
        }
        if (stream == null) {
            this.insertValue.setNull(1, -2);
            this.insertValue.setString(4, storageDesc);
        } else {
            this.insertValue.setBinaryStream(1, stream, streamLength);
            this.insertValue.setNull(4, 12);
        }
        this.insertValue.setInt(2, orderNumber);
        this.insertValue.setString(3, cid);
        return this.insertValue.executeUpdate();
    }

    @Override
    protected int deleteValueData(String cid) throws SQLException {
        if (this.deleteValue == null) {
            this.deleteValue = this.dbConnection.prepareStatement(this.DELETE_VALUE);
        } else {
            this.deleteValue.clearParameters();
        }
        this.deleteValue.setString(1, cid);
        return this.deleteValue.executeUpdate();
    }

    @Override
    protected ResultSet findValuesByPropertyId(String cid) throws SQLException {
        if (this.findValuesByPropertyId == null) {
            this.findValuesByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_BY_PROPERTYID);
        } else {
            this.findValuesByPropertyId.clearParameters();
        }
        this.findValuesByPropertyId.setString(1, cid);
        return this.findValuesByPropertyId.executeQuery();
    }

    @Override
    protected int renameNode(NodeData data) throws SQLException {
        if (this.renameNode == null) {
            this.renameNode = this.dbConnection.prepareStatement(this.RENAME_NODE);
        } else {
            this.renameNode.clearParameters();
        }
        this.renameNode.setString(1, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : this.getInternalId(data.getParentIdentifier()));
        this.renameNode.setString(2, data.getQPath().getName().getAsString());
        this.renameNode.setInt(3, data.getPersistedVersion());
        this.renameNode.setInt(4, data.getQPath().getIndex());
        this.renameNode.setInt(5, data.getOrderNumber());
        this.renameNode.setString(6, this.getInternalId(data.getIdentifier()));
        return this.renameNode.executeUpdate();
    }

    @Override
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        throw new UnsupportedOperationException("The method findNodesAndProperties is not supported for this type of connection use the complex queries instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteLockProperties() throws SQLException {
        PreparedStatement removeValuesStatement = null;
        Statement removeItemsStatement = null;
        try {
            removeValuesStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_SVALUE WHERE PROPERTY_ID IN (SELECT ID FROM JCR_SITEM WHERE CONTAINER_NAME = ? AND (NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner'))");
            removeValuesStatement.setString(1, this.containerConfig.containerName);
            removeItemsStatement = this.dbConnection.prepareStatement("DELETE FROM JCR_SITEM WHERE CONTAINER_NAME = ? AND (NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner')");
            removeItemsStatement.setString(1, this.containerConfig.containerName);
            removeValuesStatement.executeUpdate();
            removeItemsStatement.executeUpdate();
        }
        finally {
            if (removeValuesStatement != null) {
                try {
                    removeValuesStatement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't close statement", (Throwable)e);
                }
            }
            if (removeItemsStatement != null) {
                try {
                    removeItemsStatement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't close statement", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected ResultSet findNodesCount() throws SQLException {
        if (this.findNodesCount == null) {
            this.findNodesCount = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT);
        } else {
            this.findNodesCount.clearParameters();
        }
        this.findNodesCount.setString(1, this.containerConfig.containerName);
        return this.findNodesCount.executeQuery();
    }

    @Override
    protected ResultSet findMaxPropertyVersion(String parentId, String name, int index) throws SQLException {
        if (this.findMaxPropertyVersions == null) {
            this.findMaxPropertyVersions = this.dbConnection.prepareStatement(this.FIND_MAX_PROPERTY_VERSIONS);
        }
        this.findMaxPropertyVersions.setString(1, this.getInternalId(parentId));
        this.findMaxPropertyVersions.setString(2, this.containerConfig.containerName);
        this.findMaxPropertyVersions.setString(3, name);
        this.findMaxPropertyVersions.setInt(4, index);
        return this.findMaxPropertyVersions.executeQuery();
    }

    @Override
    protected ResultSet findWorkspaceDataSize() throws SQLException {
        if (this.findWorkspaceDataSize == null) {
            this.findWorkspaceDataSize = this.dbConnection.prepareStatement(this.FIND_WORKSPACE_DATA_SIZE);
        }
        this.findWorkspaceDataSize.setString(1, this.containerConfig.containerName);
        return this.findWorkspaceDataSize.executeQuery();
    }

    @Override
    protected ResultSet findNodeDataSize(String parentId) throws SQLException {
        if (this.findNodeDataSize == null) {
            this.findNodeDataSize = this.dbConnection.prepareStatement(this.FIND_NODE_DATA_SIZE);
        }
        this.findNodeDataSize.setString(1, parentId);
        this.findNodeDataSize.setString(2, this.containerConfig.containerName);
        return this.findNodeDataSize.executeQuery();
    }

    @Override
    protected ResultSet findWorkspacePropertiesOnValueStorage() throws SQLException {
        if (this.findWorkspacePropertiesOnValueStorage == null) {
            this.findWorkspacePropertiesOnValueStorage = this.dbConnection.prepareStatement(this.FIND_WORKSPACE_PROPERTIES_ON_VALUE_STORAGE);
        }
        this.findWorkspacePropertiesOnValueStorage.setString(1, this.containerConfig.containerName);
        return this.findWorkspacePropertiesOnValueStorage.executeQuery();
    }

    @Override
    protected ResultSet findNodePropertiesOnValueStorage(String parentId) throws SQLException {
        if (this.findNodePropertiesOnValueStorage == null) {
            this.findNodePropertiesOnValueStorage = this.dbConnection.prepareStatement(this.FIND_NODE_PROPERTIES_ON_VALUE_STORAGE);
        }
        this.findNodePropertiesOnValueStorage.setString(1, parentId);
        this.findNodePropertiesOnValueStorage.setString(2, this.containerConfig.containerName);
        return this.findNodePropertiesOnValueStorage.executeQuery();
    }

    @Override
    protected ResultSet findValueStorageDescAndSize(String cid) throws SQLException {
        if (this.findValueStorageDescAndSize == null) {
            this.findValueStorageDescAndSize = this.dbConnection.prepareStatement(this.FIND_VALUE_STORAGE_DESC_AND_SIZE);
        }
        this.findValueStorageDescAndSize.setString(1, cid);
        return this.findValueStorageDescAndSize.executeQuery();
    }
}

