/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.infinispan;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.infinispan.ManagedConnectionFactoryConfiguration;
import org.exoplatform.services.jdbc.DataSourceProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.transaction.xa.GlobalTransaction;

public class ManagedConnectionFactory
extends ConnectionFactory {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ManagedConnectionFactory");
    private static final boolean trace = LOG.isTraceEnabled();
    private DataSource dataSource;
    private String datasourceName;
    private boolean managed;
    static final ThreadLocal<Connection> connection = new ThreadLocal();

    private DataSourceProvider getDataSourceProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container == null) {
            LOG.warn((Object)"The current container cannot be found which prevents to retrieve the DataSourceProvider");
            return null;
        }
        DataSourceProvider dsProvider = (DataSourceProvider)container.getComponentInstanceOfType(DataSourceProvider.class);
        if (dsProvider == null) {
            LOG.warn((Object)("The DataSourceProvider cannot be found in the container " + container.getContext().getName() + ", it will be considered as non managed "));
        }
        return dsProvider;
    }

    public void start(ConnectionFactoryConfiguration factoryConfiguration, ClassLoader classLoader) throws PersistenceException {
        InitialContext ctx = null;
        DataSourceProvider dsProvider = this.getDataSourceProvider();
        if (!(factoryConfiguration instanceof ManagedConnectionFactoryConfiguration)) {
            throw new PersistenceException("FactoryConfiguration has to be an instance of ManagedConnectionFactoryConfiguration");
        }
        ManagedConnectionFactoryConfiguration managedConfiguration = (ManagedConnectionFactoryConfiguration)factoryConfiguration;
        this.datasourceName = managedConfiguration.jndiUrl();
        try {
            if (dsProvider == null) {
                ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(this.datasourceName);
            } else {
                this.dataSource = dsProvider.getDataSource(this.datasourceName);
                this.managed = dsProvider.isManaged(this.datasourceName);
            }
            if (trace) {
                LOG.trace("Datasource lookup for {} succeeded: {} of type {}", new Object[]{this.datasourceName, this.dataSource, this.managed});
            }
            if (this.dataSource == null) {
                throw new PersistenceException(String.format("Could not find a connection in jndi under the name '%s'", this.datasourceName));
            }
        }
        catch (NamingException e) {
            throw new PersistenceException((Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    LOG.debug((Object)("Could not close the context: " + e.getMessage()));
                }
            }
        }
    }

    public void stop() {
    }

    public void prepare(GlobalTransaction tx) throws PersistenceException {
        Connection con = this.getConnection(false);
        connection.set(con);
        if (trace) {
            LOG.trace((Object)("opened tx connection: tx=" + tx + ", con=" + con));
        }
    }

    public Connection getConnection() throws PersistenceException {
        return this.getConnection(true);
    }

    private Connection getConnection(boolean autoCommit) throws PersistenceException {
        Connection con = connection.get();
        if (con == null) {
            con = this.checkoutConnection();
            try {
                if (con.getAutoCommit() != autoCommit) {
                    con.setAutoCommit(autoCommit);
                }
            }
            catch (Exception e) {
                this.reportAndRethrowError("Failed to set auto-commit to " + autoCommit, e);
            }
        }
        if (trace) {
            LOG.trace((Object)("using connection: " + con));
        }
        return con;
    }

    private Connection checkoutConnection() throws PersistenceException {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to get connection for datasource=" + this.datasourceName, (Throwable)e);
        }
        if (trace) {
            LOG.trace("Connection checked out: {}", new Object[]{connection});
        }
        return connection;
    }

    public void releaseConnection(Connection con) {
        if (con != null && con != connection.get()) {
            try {
                con.close();
                if (trace) {
                    LOG.trace((Object)("closed non tx connection: " + con));
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)("Failed to close connection " + con), (Throwable)e);
            }
        }
    }

    private void closeTxConnection(Connection con) {
        this.safeClose(con);
        connection.set(null);
    }

    private void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }

    private void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        LOG.error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }
}

