/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gatein.management.api.model.Model;
import org.gatein.management.api.model.ModelBoolean;
import org.gatein.management.api.model.ModelList;
import org.gatein.management.api.model.ModelNumber;
import org.gatein.management.api.model.ModelObject;
import org.gatein.management.api.model.ModelReference;
import org.gatein.management.api.model.ModelString;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.core.api.model.DmrModel;
import org.gatein.management.core.api.model.DmrModelBoolean;
import org.gatein.management.core.api.model.DmrModelList;
import org.gatein.management.core.api.model.DmrModelNumber;
import org.gatein.management.core.api.model.DmrModelObject;
import org.gatein.management.core.api.model.DmrModelReference;
import org.gatein.management.core.api.model.DmrModelString;
import org.jboss.dmr.ModelNode;

public abstract class DmrModelValue
implements ModelValue {
    final ModelNode value;

    DmrModelValue(ModelNode value) {
        this.value = value;
    }

    public boolean isDefined() {
        return this.getValueType() != ModelValue.ModelValueType.UNDEFINED;
    }

    public <T extends ModelValue> T asValue(Class<T> valueType) {
        if (valueType.isAssignableFrom(this.getClass())) {
            return (T)((ModelValue)valueType.cast(this));
        }
        if (this.getValueType() == ModelValue.ModelValueType.UNDEFINED) {
            DmrModelValue mv;
            if (ModelReference.class.isAssignableFrom(valueType)) {
                mv = new DmrModelReference(this.value);
            } else if (ModelObject.class.isAssignableFrom(valueType)) {
                mv = new DmrModelObject(this.value);
            } else if (ModelList.class.isAssignableFrom(valueType)) {
                mv = new DmrModelList(this.value);
            } else if (ModelString.class.isAssignableFrom(valueType)) {
                mv = new DmrModelString(this.value);
            } else if (ModelNumber.class.isAssignableFrom(valueType)) {
                mv = new DmrModelNumber(this.value);
            } else if (ModelBoolean.class.isAssignableFrom(valueType)) {
                mv = new DmrModelBoolean(this.value);
            } else {
                throw new IllegalArgumentException("No mapping defined for ModelValue type " + valueType);
            }
            return (T)((ModelValue)valueType.cast(mv));
        }
        ModelValue value = DmrModelValue.asValue(this.value);
        try {
            return (T)((ModelValue)valueType.cast(value));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("ModelValue type is " + value.getValueType() + " and cannot be cast to " + valueType.getName());
        }
    }

    public final ModelValue.ModelValueType getValueType() {
        return DmrModelValue.getValueType(this.value);
    }

    public String toString() {
        return this.toJsonString(false);
    }

    public String toJsonString(boolean pretty) {
        StringWriter sw = new StringWriter();
        this.toJson(new PrintWriter(sw), pretty);
        return sw.toString();
    }

    public void toJsonStream(OutputStream outputStream, boolean pretty) {
        this.toJson(new PrintWriter(outputStream), pretty);
    }

    private void toJson(PrintWriter writer, boolean pretty) {
        this.value.writeJSONString(writer, !pretty);
        if (pretty) {
            writer.write(10);
        }
        writer.flush();
    }

    public ModelValue fromJsonString(String json) {
        return DmrModelValue.readFromJsonString(json);
    }

    public <T extends ModelValue> T fromJsonString(String json, Class<T> valueType) {
        return DmrModelValue.readFromJsonString(json, valueType);
    }

    public ModelValue fromJsonStream(InputStream inputStream) throws IOException {
        return DmrModelValue.readFromJsonStream(inputStream);
    }

    public <T extends ModelValue> T fromJsonStream(InputStream inputStream, Class<T> valueType) throws IOException {
        return DmrModelValue.readFromJsonStream(inputStream, valueType);
    }

    public static ModelValue readFromJsonStream(InputStream inputStream) throws IOException {
        try {
            return DmrModelValue.asValue(ModelNode.fromJSONStream((InputStream)inputStream));
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static <T extends ModelValue> T readFromJsonStream(InputStream inputStream, Class<T> valueType) throws IOException {
        return (T)((ModelValue)valueType.cast(DmrModelValue.readFromJsonStream(inputStream)));
    }

    public static ModelValue readFromJsonString(String json) {
        return DmrModelValue.asValue(ModelNode.fromJSONString((String)json));
    }

    public static <T extends ModelValue> T readFromJsonString(String json, Class<T> valueType) {
        return (T)((ModelValue)valueType.cast(DmrModelValue.readFromJsonString(json)));
    }

    public static Model newModel() {
        return new DmrModel(new ModelNode());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof DmrModelValue && this.equals((DmrModelValue)other);
    }

    public boolean equals(DmrModelValue other) {
        return this.value.equals(other.value);
    }

    static ModelValue asValue(ModelNode value) {
        ModelValue.ModelValueType valueType = DmrModelValue.getValueType(value);
        switch (valueType) {
            case LIST: {
                return new DmrModelList(value);
            }
            case REFERENCE: {
                return new DmrModelReference(value);
            }
            case OBJECT: {
                return new DmrModelObject(value);
            }
            case BOOLEAN: {
                return new DmrModelBoolean(value);
            }
            case NUMBER: {
                return new DmrModelNumber(value);
            }
            case STRING: {
                return new DmrModelString(value);
            }
            case UNDEFINED: {
                return new DmrModel(value);
            }
        }
        throw new AssertionError(valueType);
    }

    private static ModelValue.ModelValueType getValueType(ModelNode value) {
        switch (value.getType()) {
            case LIST: {
                return ModelValue.ModelValueType.LIST;
            }
            case OBJECT: {
                if (DmrModelReference.isReference(value)) {
                    return ModelValue.ModelValueType.REFERENCE;
                }
                return ModelValue.ModelValueType.OBJECT;
            }
            case BOOLEAN: {
                return ModelValue.ModelValueType.BOOLEAN;
            }
            case BIG_DECIMAL: 
            case BIG_INTEGER: 
            case DOUBLE: 
            case INT: 
            case LONG: {
                return ModelValue.ModelValueType.NUMBER;
            }
            case STRING: {
                return ModelValue.ModelValueType.STRING;
            }
            case UNDEFINED: {
                return ModelValue.ModelValueType.UNDEFINED;
            }
        }
        throw new IllegalStateException("No mapping for model type " + value.getType());
    }
}

