/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.operation.global;

import java.util.Map;
import java.util.Set;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.QueryOperationHandler;
import org.gatein.management.api.operation.model.NamedDescription;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.management.core.api.operation.global.ExportResource;

public class GlobalOperationHandlers {
    public static final ExportResource EXPORT_RESOURCE = new ExportResource();
    public static final ReadResource READ_RESOURCE = new ReadResource();

    private GlobalOperationHandlers() {
    }

    public static final class ReadResource
    extends QueryOperationHandler<ReadResourceModel>
    implements ManagedDescription {
        public ReadResourceModel execute(OperationContext operationContext) {
            ManagedResource resource = operationContext.getManagedResource();
            PathAddress address = operationContext.getAddress();
            Set children = resource.getSubResourceNames(address);
            ReadResourceModel readResourceModel = new ReadResourceModel("Available operations and children (sub-resources).", children);
            for (String child : children) {
                ManagedDescription managedDescription = resource.getResourceDescription(address.append(child));
                readResourceModel.setChildDescription(child, managedDescription.getDescription());
            }
            Map descriptions = resource.getOperationDescriptions(address);
            for (Map.Entry entry : descriptions.entrySet()) {
                readResourceModel.addOperation(new NamedDescription((String)entry.getKey(), ((ManagedDescription)entry.getValue()).getDescription()));
            }
            return readResourceModel;
        }

        public String getDescription() {
            return "Lists information about a managed resource, including available operations and children (sub-resources).";
        }
    }
}

