/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.ReflectionUtil;
import org.exoplatform.services.database.annotation.Table;
import org.exoplatform.services.database.annotation.TableField;

public class ReflectionMapper<T extends DBObject>
implements DBObjectMapper<T> {
    @Override
    public String[][] toParameters(T bean) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        this.getParameters(bean, bean.getClass(), map);
        String[][] parameters = new String[map.size()][2];
        Iterator iter = map.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            parameters[i][0] = (String)iter.next();
            parameters[i][1] = (String)map.get(parameters[i][0]);
            ++i;
        }
        return parameters;
    }

    private void getParameters(Object bean, Class<?> clazz, Map<String, String> map) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object value = ReflectionUtil.getValue(bean, fields[i]);
            if (value == null) {
                value = new String();
            }
            if (value instanceof Calendar) {
                value = new Date(((Calendar)value).getTimeInMillis());
            } else if (value instanceof java.util.Date) {
                value = new Date(((java.util.Date)value).getTime());
            }
            map.put(fields[i].getName(), value.toString());
        }
        if (clazz == DBObject.class) {
            return;
        }
        Class<?> superClazz = clazz.getSuperclass();
        this.getParameters(superClazz.cast(bean), superClazz, map);
    }

    @Override
    public void mapResultSet(ResultSet resultSet, T bean) throws Exception {
        Class<?> clazz = bean.getClass();
        Table table = clazz.getAnnotation(Table.class);
        TableField[] tableFields = table.field();
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        for (int i = 1; i <= numberOfColumns; ++i) {
            String fieldName;
            Field field;
            String name = rsmd.getColumnName(i);
            TableField tableField = this.searchTableField(tableFields, name);
            if (tableField == null || (field = this.getField(clazz, fieldName = tableField.field().length() == 0 ? tableField.name() : tableField.field())) == null) continue;
            ReflectionUtil.setValue(bean, field, this.getValue(rsmd.getColumnType(i), resultSet, name));
        }
    }

    @Override
    public void mapUpdate(T bean, PreparedStatement statement) throws Exception {
        Class<?> clazz = bean.getClass();
        Table table = clazz.getAnnotation(Table.class);
        TableField[] tableFields = table.field();
        int i = 1;
        for (TableField tableField : tableFields) {
            String fieldName = tableField.field().length() == 0 ? tableField.name() : tableField.field();
            Field field = this.getField(clazz, fieldName);
            if (field == null) continue;
            statement.setObject(i, ReflectionUtil.getValue(bean, field));
            ++i;
        }
    }

    private Field getField(Class<?> clazz, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        if (field != null) {
            return field;
        }
        if (clazz == DBObject.class) {
            return null;
        }
        return this.getField(clazz.getSuperclass(), name);
    }

    private Object getValue(int type, ResultSet resultSet, String name) throws Exception {
        switch (type) {
            case 2005: {
                return this.loadClob(resultSet, name);
            }
            case 2004: {
                return this.loadBlob(resultSet, name);
            }
            case -2: {
                return this.loadBinary(resultSet, name);
            }
        }
        return resultSet.getObject(name.toUpperCase());
    }

    private synchronized byte[] loadBinary(ResultSet resultSet, String name) throws Exception {
        InputStream input = resultSet.getBinaryStream(name);
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream output = this.loadInputStream(input);
        return output.toByteArray();
    }

    private synchronized byte[] loadBlob(ResultSet resultSet, String name) throws Exception {
        Blob clob = resultSet.getBlob(name);
        if (clob == null) {
            return null;
        }
        ByteArrayOutputStream output = this.loadInputStream(clob.getBinaryStream());
        return output.toByteArray();
    }

    private synchronized String loadClob(ResultSet resultSet, String name) throws Exception {
        String line;
        Clob clob = resultSet.getClob(name);
        if (clob == null) {
            return null;
        }
        Reader input = clob.getCharacterStream();
        if (input == null) {
            return null;
        }
        LineNumberReader lineReader = new LineNumberReader(input);
        StringBuilder builder = new StringBuilder();
        while ((line = lineReader.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }

    private ByteArrayOutputStream loadInputStream(InputStream input) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int available = -1;
        while ((available = input.read(data)) > -1) {
            output.write(data, 0, available);
        }
        return output;
    }

    private TableField searchTableField(TableField[] tableFields, String name) {
        for (TableField tableField : tableFields) {
            if (!tableField.name().equals(name) || tableField.field().length() <= 0) continue;
            return tableField;
        }
        for (TableField field : tableFields) {
            if (!field.name().equals(name) || field.field().length() >= 1) continue;
            return field;
        }
        return null;
    }
}

