/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.creator;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreatorException;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.database.utils.JDBCUtils;

public class DBCreator {
    private static final String CONNECTION_PROPERTIES = "db-connection";
    private static final String DRIVER_NAME = "driverClassName";
    private static final String SERVER_URL = "url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String DB_CREATION_PROPERTIES = "db-creation";
    private static final String DB_SCRIPT_PATH = "scriptPath";
    private static final String DB_USERNAME = "username";
    private static final String DB_PASSWORD = "password";
    public static final String DATABASE_TEMPLATE = "${database}";
    public static final String USERNAME_TEMPLATE = "${username}";
    public static final String PASSWORD_TEMPLATE = "${password}";
    protected final String serverUrl;
    protected final Map<String, String> connectionProperties;
    protected final String dbScript;
    protected final String dbUserName;
    protected final String dbPassword;

    public DBCreator(String serverUrl, Map<String, String> connectionProperties, String scriptPath, String dbUserName, String dbPassword, ConfigurationManager cm) throws ConfigurationException {
        this.serverUrl = serverUrl;
        this.connectionProperties = connectionProperties;
        this.dbUserName = dbUserName;
        this.dbPassword = dbPassword;
        this.dbScript = this.readScript(scriptPath, cm);
    }

    public DBCreator(InitParams params, ConfigurationManager cm) throws ConfigurationException {
        if (params == null) {
            throw new ConfigurationException("Initializations parameters expected");
        }
        PropertiesParam prop = params.getPropertiesParam(CONNECTION_PROPERTIES);
        if (prop != null) {
            if (prop.getProperty(DRIVER_NAME) == null) {
                throw new ConfigurationException("driverClassName expected in db-connection properties section");
            }
            this.serverUrl = prop.getProperty(SERVER_URL);
            if (this.serverUrl == null) {
                throw new ConfigurationException("url expected in db-connection properties section");
            }
            if (prop.getProperty("username") == null) {
                throw new ConfigurationException("username expected in db-connection properties section");
            }
            if (prop.getProperty("password") == null) {
                throw new ConfigurationException("password expected in db-connection properties section");
            }
            Iterator pit = prop.getPropertyIterator();
            this.connectionProperties = new HashMap<String, String>();
            while (pit.hasNext()) {
                Property p = (Property)pit.next();
                if (p.getName().equalsIgnoreCase(SERVER_URL)) continue;
                this.connectionProperties.put(p.getName(), p.getValue());
            }
        } else {
            throw new ConfigurationException("db-connection properties expected in initializations parameters");
        }
        prop = params.getPropertiesParam(DB_CREATION_PROPERTIES);
        if (prop != null) {
            String scriptPath = prop.getProperty(DB_SCRIPT_PATH);
            if (scriptPath == null) {
                throw new ConfigurationException("scriptPath expected in db-creation properties section");
            }
            this.dbScript = this.readScript(scriptPath, cm);
            this.dbUserName = prop.getProperty("username");
            if (this.dbUserName == null) {
                throw new ConfigurationException("username expected in db-creation properties section");
            }
            this.dbPassword = prop.getProperty("password");
            if (this.dbPassword == null) {
                throw new ConfigurationException("password expected in db-creation properties section");
            }
        } else {
            throw new ConfigurationException("db-creation properties expected in initializations parameters");
        }
    }

    public DBConnectionInfo createDatabase(String dbName) throws DBCreatorException {
        Connection conn = this.openConnection();
        try {
            String dialect = DialectDetecter.detect(conn.getMetaData());
            if (dialect.equalsIgnoreCase("MSSQL") || dialect.equalsIgnoreCase("SYBASE")) {
                this.executeInAutoCommitMode(conn, dbName);
            } else {
                this.executeInBatchMode(conn, dbName);
            }
            DBConnectionInfo dBConnectionInfo = this.constructDBConnectionInfo(dbName, dialect);
            return dBConnectionInfo;
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't execute SQL script : " + JDBCUtils.getFullMessage(e), e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
    }

    public DBConnectionInfo getDBConnectionInfo(String dbName) throws DBCreatorException {
        Connection conn = this.openConnection();
        try {
            DBConnectionInfo dBConnectionInfo = this.constructDBConnectionInfo(dbName, DialectDetecter.detect(conn.getMetaData()));
            return dBConnectionInfo;
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can not get database connection information", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
    }

    private void executeInBatchMode(Connection conn, String dbName) throws SQLException {
        Statement statement = conn.createStatement();
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = JDBCUtils.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            statement.addBatch(s);
        }
        statement.executeBatch();
    }

    private DBConnectionInfo constructDBConnectionInfo(String dbName, String dialect) {
        StringBuilder dbUrl = new StringBuilder(this.serverUrl);
        if (dialect.equalsIgnoreCase("MSSQL")) {
            dbUrl.append(this.serverUrl.endsWith(";") ? "" : ";");
            dbUrl.append("databaseName=");
            dbUrl.append(dbName);
            dbUrl.append(";");
        } else if (!dialect.equalsIgnoreCase("ORACLE") && !dialect.equalsIgnoreCase("ORACLE-OCI")) {
            dbUrl.append(this.serverUrl.endsWith("/") ? "" : "/");
            dbUrl.append(dbName);
        }
        HashMap<String, String> connProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
            connProperties.put(entry.getKey(), entry.getValue());
        }
        connProperties.put(SERVER_URL, dbUrl.toString());
        return new DBConnectionInfo(dbName, connProperties);
    }

    private void executeInAutoCommitMode(Connection conn, String dbName) throws SQLException {
        conn.setAutoCommit(true);
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = JDBCUtils.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            conn.createStatement().executeUpdate(s);
        }
    }

    private String readScript(String scriptPath, ConfigurationManager cm) throws ConfigurationException {
        try {
            return IOUtil.getStreamContentAsString((InputStream)cm.getInputStream(scriptPath));
        }
        catch (Exception e) {
            try {
                return IOUtil.getFileContentAsString((String)scriptPath);
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Can't read script at " + scriptPath, (Throwable)e);
            }
        }
    }

    private Connection openConnection() throws DBCreatorException {
        Connection conn = null;
        try {
            ClassLoading.forName((String)this.connectionProperties.get(DRIVER_NAME), (Object)this);
            conn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return DriverManager.getConnection(DBCreator.this.serverUrl, DBCreator.this.connectionProperties.get("username"), DBCreator.this.connectionProperties.get("password"));
                }
            });
            return conn;
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't establish the JDBC connection to database " + this.serverUrl, e);
        }
        catch (ClassNotFoundException e) {
            throw new DBCreatorException("Can't load the JDBC driver " + this.connectionProperties.get(DRIVER_NAME), e);
        }
    }
}

