/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.utils;

import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DialectDetecter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.database.DialectDetecter");

    public static String detect(final DatabaseMetaData metaData) throws SQLException {
        String databaseName = (String)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return metaData.getDatabaseProductName();
            }
        });
        if ("HSQL Database Engine".equals(databaseName)) {
            return "HSQLDB";
        }
        if ("H2".equals(databaseName)) {
            return "H2";
        }
        if ("MySQL".equals(databaseName)) {
            return "MYSQL";
        }
        if ("PostgreSQL".equals(databaseName)) {
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            return majorVersion > 9 || majorVersion == 9 && minorVersion >= 1 ? "PGSQL-SCS" : "PGSQL";
        }
        if ("EnterpriseDB".equals(databaseName)) {
            return "PGSQL-SCS";
        }
        if ("Apache Derby".equals(databaseName)) {
            return "DERBY";
        }
        if ("ingres".equalsIgnoreCase(databaseName)) {
            return "INGRES";
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            return "MSSQL";
        }
        if ("Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName)) {
            return "SYBASE";
        }
        if (databaseName.startsWith("Adaptive Server Anywhere")) {
            return "SYBASE";
        }
        if (databaseName.startsWith("DB2/")) {
            return DialectDetecter.detectDB2Dialect(metaData);
        }
        if ("Oracle".equals(databaseName)) {
            return "ORACLE";
        }
        return "GENERIC";
    }

    private static String detectDB2Dialect(DatabaseMetaData metaData) throws SQLException {
        int majorVersion;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DB Major version = " + metaData.getDatabaseMajorVersion() + ", DB Minor version = " + metaData.getDatabaseMinorVersion() + ", DB Product version = " + metaData.getDatabaseProductVersion()));
        }
        if ((majorVersion = metaData.getDatabaseMajorVersion()) < 9) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The dialect DB2V8 will be used as the major version is lower than 9.");
            }
            return "DB2V8";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"The dialect DB2 will be used as the major version is greater or equal to 9");
        }
        return "DB2";
    }
}

