/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpaceAccessType {
    SUPER_ADMINISTRATOR("social.space.access.administrator"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return space != null && SpaceAccessType.getSpaceService().isSuperManager(remoteId);
        }
    }
    ,
    INVITED_SPACE("social.space.access.invited-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return SpaceAccessType.getSpaceService().isInvitedUser(space, remoteId);
        }
    }
    ,
    REQUESTED_JOIN_SPACE("social.space.access.requested-join-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return SpaceAccessType.getSpaceService().isPendingUser(space, remoteId);
        }
    }
    ,
    CLOSED_SPACE("social.space.access.closed-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return !SpaceAccessType.getSpaceService().isMember(space, remoteId) && "closed".equals(space.getRegistration());
        }
    }
    ,
    JOIN_SPACE("social.space.access.join-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return !SpaceAccessType.getSpaceService().isMember(space, remoteId) && "open".equals(space.getRegistration());
        }
    }
    ,
    REQUEST_JOIN_SPACE("social.space.access.request-join-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return !SpaceAccessType.getSpaceService().isMember(space, remoteId) && "validation".equals(space.getRegistration());
        }
    }
    ,
    NO_AUTHENTICATED("social.space.access.no-authenticated"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            return remoteId == null;
        }
    }
    ,
    SPACE_NOT_FOUND("social.space.access.space-not-found"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            boolean result = false;
            if (space == null) {
                result = true;
            } else if (space != null) {
                result = "hidden".equals(space.getVisibility()) && !SpaceAccessType.getSpaceService().isMember(space, remoteId) && "closed".equals(space.getRegistration());
            }
            return result;
        }
    }
    ,
    NOT_ACCESS_WIKI_SPACE("social.space.access.not-access-wiki-space"){

        @Override
        public boolean doCheck(String remoteId, Space space) {
            SpaceService spaceService = SpaceAccessType.getSpaceService();
            return !spaceService.isSuperManager(remoteId) && !spaceService.isMember(space, remoteId);
        }
    };

    private final String name;
    public static final String ACCESSED_TYPE_KEY = "social.accessed.space.type.key";
    public static final String ACCESSED_SPACE_PRETTY_NAME_KEY = "social.accessed.space.key";
    public static final String ACCESSED_SPACE_WIKI_PAGE_KEY = "social.accessed.space.wiki.page.key";
    public static final String ACCESSED_SPACE_REQUEST_PATH_KEY = "social.accessed.space.request.path.key";
    public static final String NODE_REDIRECT = "space-access";

    private SpaceAccessType(String name) {
        this.name = name;
    }

    private static SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean doCheck(String var1, Space var2);
}

