/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model;

import org.apache.commons.lang3.StringUtils;

public enum WalletType {
    USER,
    SPACE,
    ADMIN;

    private String id = this.name().toLowerCase();
    private String providerId;

    private WalletType() {
        switch (this.ordinal()) {
            case 0: {
                this.providerId = "organization";
                break;
            }
            case 1: {
                this.providerId = "space";
                break;
            }
            case 2: {
                this.providerId = "WALLET_ADMIN";
                break;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public boolean isSpace() {
        return this == SPACE;
    }

    public boolean isUser() {
        return this == USER;
    }

    public boolean isAdmin() {
        return this == ADMIN;
    }

    public static WalletType getType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return USER;
        }
        switch (type.toUpperCase()) {
            case "SPACE": {
                return SPACE;
            }
            case "ADMIN": {
                return ADMIN;
            }
            case "USER": {
                return USER;
            }
        }
        switch (type) {
            case "space": {
                return SPACE;
            }
            case "WALLET_ADMIN": {
                return ADMIN;
            }
            case "organization": {
                return USER;
            }
        }
        return USER;
    }

    public static boolean isSpace(String type) {
        return WalletType.getType(type) == SPACE;
    }

    public static boolean isUser(String type) {
        return WalletType.getType(type) == USER;
    }

    public static boolean isAdmin(String type) {
        return WalletType.getType(type) == ADMIN;
    }
}

