/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionControlCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.VersionControlCommand");

    public Response versionControl(Session session, String path) {
        try {
            Node node = (Node)session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                node.addMixin("mix:versionable");
                session.save();
            }
            return Response.ok().build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }
}

