/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.DownloadDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNtFileFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={DownloadActionListener.class})})
public class DownloadManageComponent
extends UIAbstractManagerComponent {
    private static final Log LOG = ExoLogger.getLogger((String)DownloadManageComponent.class.getName());
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNtFileFilter(), new DownloadDocumentFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    private String[] parseWorkSpaceNameAndNodePath(String nodePath) {
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        if (!matcher.find()) {
            return null;
        }
        String[] workSpaceNameAndNodePath = new String[]{matcher.group(1), matcher.group(2)};
        return workSpaceNameAndNodePath;
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        return sessionProvider.getSession(workspaceName, WCMCoreUtils.getRepository());
    }

    public static class DownloadActionListener
    extends UIWorkingAreaActionListener<DownloadManageComponent> {
        public void processEvent(Event<DownloadManageComponent> event) throws Exception {
            DownloadManageComponent downloadManageComponent = (DownloadManageComponent)((Object)event.getSource());
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            String[] workspaceAndPath = downloadManageComponent.parseWorkSpaceNameAndNodePath(nodePath);
            Node downloadedNode = (Node)((NodeFinder)WCMCoreUtils.getService(NodeFinder.class)).getItem(downloadManageComponent.getSession(workspaceAndPath[0]), workspaceAndPath[1], true);
            String downloadLink = Utils.getDownloadLink((Node)downloadedNode);
            event.getRequestContext().getJavascriptManager().require("SHARED/jquery", "gj").addScripts("setTimeout(\"window.location.assign('" + downloadLink + "');\", 1000);");
        }
    }
}

